/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.survivalist.slime;

import gigaherz.survivalist.ConfigManager;
import gigaherz.survivalist.SurvivalistMod;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class SlimeMerger {
    private static final int BIG_SLIME = 8;
    private static final int AGE_LIMIT = 200;
    private static Random rand = new Random();

    public static void register() {
        MinecraftForge.EVENT_BUS.register((Object)new SlimeMerger());
    }

    @SubscribeEvent
    public void slimeConstruct(EntityJoinWorldEvent event) {
        if (!((Boolean)ConfigManager.SERVER.mergeSlimes.get()).booleanValue()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof SlimeEntity)) {
            return;
        }
        SlimeEntity slime = (SlimeEntity)entity;
        slime.field_70714_bg.func_75776_a(7, (Goal)new MergeWithNearbySlimesGoal(slime));
        slime.field_70715_bh.func_75776_a(5, (Goal)new MoveTowardNearestSlimeGoal(slime));
    }

    private static boolean isValidTarget(SlimeEntity slime, LivingEntity entity) {
        return entity != slime && entity.func_70089_S() && entity.getClass() == slime.getClass() && entity.field_70173_aa >= 200 && ((SlimeEntity)entity).func_70809_q() == slime.func_70809_q();
    }

    public static class MoveTowardNearestSlimeGoal
    extends NearestAttackableTargetGoal<SlimeEntity> {
        private static final int EXECUTE_CHANCE = 20;
        private final SlimeEntity slime;

        public MoveTowardNearestSlimeGoal(SlimeEntity mobIn) {
            super((MobEntity)mobIn, SlimeEntity.class, 20, true, true, null);
            this.slime = mobIn;
            this.field_220779_d = new EntityPredicate().func_221009_d().func_221014_c().func_221013_a(this.func_111175_f()).func_221012_a(other -> SlimeMerger.isValidTarget(this.slime, other));
        }

        public boolean func_75250_a() {
            if (this.slime.func_70809_q() >= 8) {
                return false;
            }
            if (this.slime.field_70173_aa < 200) {
                return false;
            }
            if (rand.nextFloat() > 0.05f) {
                return false;
            }
            return super.func_75250_a();
        }

        public boolean func_75253_b() {
            if (rand.nextFloat() < 0.01f) {
                return false;
            }
            return super.func_75253_b();
        }
    }

    public static class Sorter
    implements Comparator<Entity> {
        private final Entity entity;

        public Sorter(Entity entityIn) {
            this.entity = entityIn;
        }

        @Override
        public int compare(Entity p_compare_1_, Entity p_compare_2_) {
            double d1;
            double d0 = this.entity.func_70068_e(p_compare_1_);
            if (d0 < (d1 = this.entity.func_70068_e(p_compare_2_))) {
                return -1;
            }
            return d0 > d1 ? 1 : 0;
        }
    }

    static class MergeWithNearbySlimesGoal
    extends Goal {
        private static Method setSlimeSizeMethod = ObfuscationReflectionHelper.findMethod(SlimeEntity.class, (String)"setSlimeSize", (Class[])new Class[]{Integer.TYPE, Boolean.TYPE});
        private final SlimeEntity slime;
        private final Sorter sorter;

        public MergeWithNearbySlimesGoal(SlimeEntity slimeIn) {
            this.slime = slimeIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
            this.sorter = new Sorter((Entity)slimeIn);
        }

        private List<SlimeEntity> findOtherSlimes() {
            return this.slime.field_70170_p.func_175647_a(SlimeEntity.class, this.slime.func_174813_aQ().func_72314_b((double)this.slime.func_70809_q() * 1.5, (double)this.slime.func_70809_q(), (double)this.slime.func_70809_q() * 1.5), other -> SlimeMerger.isValidTarget(this.slime, (LivingEntity)other));
        }

        public boolean func_75250_a() {
            if (this.slime.func_70809_q() >= 8) {
                return false;
            }
            if (this.slime.field_70173_aa < 200) {
                return false;
            }
            if ((double)rand.nextFloat() > 0.5) {
                return false;
            }
            return this.findOtherSlimes().size() >= 3;
        }

        public void func_75249_e() {
            List<SlimeEntity> list = this.findOtherSlimes();
            if (list.size() >= 3) {
                int i;
                Collections.sort(list, this.sorter);
                double x = this.slime.func_226277_ct_();
                double y = this.slime.func_226278_cu_();
                double z = this.slime.func_226281_cx_();
                int size = this.slime.func_70809_q() + 1;
                for (i = 0; i < 8 * size; ++i) {
                    float angle = rand.nextFloat();
                    float speed = (float)size * (1.0f + rand.nextFloat() * 0.5f);
                    this.slime.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197592_C, this.slime.func_226277_ct_(), this.slime.func_226278_cu_(), this.slime.func_226281_cx_(), (double)speed * Math.cos(angle), 1.0, (double)speed * Math.sin(angle));
                }
                for (i = 0; i < 3; ++i) {
                    SlimeEntity target = list.get(i);
                    x += target.func_226277_ct_();
                    y += target.func_226278_cu_();
                    z += target.func_226281_cx_();
                    target.func_70106_y();
                    for (int j = 0; j < 8 * size; ++j) {
                        float angle = rand.nextFloat();
                        float speed = (float)size * (1.0f + rand.nextFloat() * 0.5f);
                        this.slime.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197592_C, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), (double)speed * Math.cos(angle), 1.0, (double)speed * Math.sin(angle));
                    }
                }
                x /= 4.0;
                y /= 4.0;
                z /= 4.0;
                int newSize = this.slime.func_70809_q() + 1;
                try {
                    setSlimeSizeMethod.invoke((Object)this.slime, newSize, true);
                    this.slime.func_70107_b(x, y, z);
                }
                catch (ReflectiveOperationException e) {
                    throw new ReportedException(new CrashReport("Could not call method '" + setSlimeSizeMethod.getName() + "'", (Throwable)e));
                }
                this.slime.func_184185_a((SoundEvent)SurvivalistMod.SOUND_SHLOP.get(), 1.0f, 0.8f + rand.nextFloat() * 0.4f);
            }
            super.func_75249_e();
        }

        public boolean func_75253_b() {
            return false;
        }
    }
}

