/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.survivalist.util;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.mojang.datafixers.types.Type;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.NonNullLazy;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RegSitter {
    private final List<DeferredRegister<?>> registerList = Lists.newArrayList();
    private final NonNullLazy<DeferredRegister<Block>> BLOCKS = NonNullLazy.of(() -> this.createDeferred(ForgeRegistries.BLOCKS));
    private final NonNullLazy<DeferredRegister<Item>> ITEMS = NonNullLazy.of(() -> this.createDeferred(ForgeRegistries.ITEMS));
    private final NonNullLazy<DeferredRegister<TileEntityType<?>>> TILE_ENTITIES = NonNullLazy.of(() -> this.createDeferred(ForgeRegistries.TILE_ENTITIES));
    private final NonNullLazy<DeferredRegister<SoundEvent>> SOUND_EVENTS = NonNullLazy.of(() -> this.createDeferred(ForgeRegistries.SOUND_EVENTS));
    private final NonNullLazy<DeferredRegister<Enchantment>> ENCHANTMENTS = NonNullLazy.of(() -> this.createDeferred(ForgeRegistries.ENCHANTMENTS));
    private final NonNullLazy<DeferredRegister<EntityType<?>>> ENTITIES = NonNullLazy.of(() -> this.createDeferred(ForgeRegistries.ENTITIES));
    private final String modId;

    public RegSitter(String modId) {
        this.modId = modId;
    }

    private <T extends IForgeRegistryEntry<T>> DeferredRegister<T> createDeferred(IForgeRegistry<T> registry) {
        DeferredRegister deferred = DeferredRegister.create(registry, (String)this.modId);
        this.registerList.add(deferred);
        return deferred;
    }

    public final void subscribeEvents(IEventBus bus) {
        this.registerList.forEach(def -> def.register(bus));
    }

    public <T extends Block> RegistryObject<T> block(String name) {
        return RegistryObject.of((ResourceLocation)new ResourceLocation(this.modId, name), (IForgeRegistry)ForgeRegistries.BLOCKS);
    }

    public <T extends Item> RegistryObject<T> item(String name) {
        return RegistryObject.of((ResourceLocation)new ResourceLocation(this.modId, name), (IForgeRegistry)ForgeRegistries.ITEMS);
    }

    public <T extends TileEntity> RegistryObject<TileEntityType<T>> tileEntity(String name) {
        return RegistryObject.of((ResourceLocation)new ResourceLocation(this.modId, name), (IForgeRegistry)ForgeRegistries.TILE_ENTITIES);
    }

    public final <T extends Block> MiniBlock<T> block(String name, Supplier<T> factory) {
        return new MiniBlock(name, factory);
    }

    public final <T extends Item> MiniGeneric<T> item(String name, Supplier<T> factory) {
        return new MiniGeneric((NonNullSupplier)this.ITEMS, name, factory);
    }

    @SafeVarargs
    public final <T extends TileEntity> MiniTileEntity<T> tileEntity(String name, Supplier<T> factory, RegistryObject<? extends Block> ... blocks) {
        return new MiniTileEntity((NonNullSupplier)this.TILE_ENTITIES, name, factory, (Set)ImmutableSet.copyOf((Object[])blocks));
    }

    public final <T extends SoundEvent> MiniGeneric<T> soundEvent(String name, Supplier<T> factory) {
        return new MiniGeneric((NonNullSupplier)this.SOUND_EVENTS, name, factory);
    }

    public final <T extends Enchantment> MiniGeneric<T> enchantment(String name, Supplier<T> factory) {
        return new MiniGeneric((NonNullSupplier)this.ENCHANTMENTS, name, factory);
    }

    public final <T extends Entity> MiniEntity<T> entityType(String name, EntityType.IFactory<T> factory, EntityClassification classification) {
        return new MiniEntity((NonNullSupplier)this.ENTITIES, name, (EntityType.IFactory)factory, classification);
    }

    public static class MiniGeneric<T extends IForgeRegistryEntry<? super T>> {
        private final NonNullSupplier<? extends DeferredRegister<? super T>> deferred;
        private final Supplier<? extends T> factory;
        protected final String name;

        private MiniGeneric(NonNullSupplier<? extends DeferredRegister<? super T>> deferred, String name, Supplier<? extends T> factory) {
            this.deferred = deferred;
            this.name = name;
            this.factory = factory;
        }

        protected Supplier<? extends T> factory() {
            return this.factory;
        }

        public RegistryObject<T> defer() {
            return ((DeferredRegister)this.deferred.get()).register(this.name, this.factory());
        }
    }

    public class MiniEntity<T extends Entity>
    extends MiniGeneric<EntityType<T>> {
        private EntityType.Builder<T> builder;

        private MiniEntity(NonNullSupplier<? extends DeferredRegister<? super EntityType<T>>> deferred, String name, EntityType.IFactory<T> factory, EntityClassification classification) {
            super(deferred, name, null);
            this.builder = EntityType.Builder.func_220322_a(factory, (EntityClassification)classification);
        }

        @Override
        protected Supplier<? extends EntityType<T>> factory() {
            return this::build;
        }

        private EntityType<T> build() {
            return this.builder.func_206830_a(new ResourceLocation(RegSitter.this.modId, this.name).toString());
        }

        public MiniEntity<T> size(float width, float height) {
            this.builder.func_220321_a(width, height);
            return this;
        }

        public MiniEntity<T> disableSummoning() {
            this.builder.func_200705_b();
            return this;
        }

        public MiniEntity<T> disableSerialization() {
            this.builder.func_200706_c();
            return this;
        }

        public MiniEntity<T> immuneToFire() {
            this.builder.func_220320_c();
            return this;
        }

        public MiniEntity<T> spawnableFarFromPlayer() {
            this.builder.func_225435_d();
            return this;
        }

        public MiniEntity<T> setUpdateInterval(int interval) {
            this.builder.setUpdateInterval(interval);
            return this;
        }

        public MiniEntity<T> setTrackingRange(int range) {
            this.builder.setTrackingRange(range);
            return this;
        }

        public MiniEntity<T> setShouldReceiveVelocityUpdates(boolean value) {
            this.builder.setShouldReceiveVelocityUpdates(value);
            return this;
        }

        public MiniEntity<T> setCustomClientFactory(BiFunction<FMLPlayMessages.SpawnEntity, World, T> customClientFactory) {
            this.builder.setCustomClientFactory(customClientFactory);
            return this;
        }
    }

    public class MiniTileEntity<T extends TileEntity>
    extends MiniGeneric<TileEntityType<T>> {
        private final Supplier<? extends T> factory;
        private final Set<RegistryObject<? extends Block>> blocks;
        private Type<?> dataFixerType;

        private MiniTileEntity(NonNullSupplier<? extends DeferredRegister<? super TileEntityType<T>>> deferred, String name, Supplier<? extends T> factory, Set<RegistryObject<? extends Block>> blocks) {
            super(deferred, name, null);
            this.dataFixerType = null;
            this.factory = factory;
            this.blocks = blocks;
        }

        @Override
        protected Supplier<? extends TileEntityType<T>> factory() {
            return this::build;
        }

        private TileEntityType<T> build() {
            return new TileEntityType(this.factory, (Set)ImmutableSet.copyOf(this.blocks.stream().map(RegistryObject::get).iterator()), this.dataFixerType);
        }
    }

    public class MiniBlock<T extends Block>
    extends MiniGeneric<T> {
        private Function<Supplier<T>, ? extends Item> itemFactory;
        private Function<Supplier<T>, ? extends TileEntityType<?>> tileEntityFactory;

        private MiniBlock(String name, Supplier<T> factory) {
            super((NonNullSupplier)RegSitter.this.BLOCKS, name, factory);
        }

        public MiniBlock<T> withItem() {
            return this.withItem(new Item.Properties());
        }

        public MiniBlock<T> withItem(Item.Properties properties) {
            return this.withItem((Supplier<T> block) -> new BlockItem((Block)block.get(), properties));
        }

        public MiniBlock<T> withItem(Function<Supplier<T>, ? extends Item> itemFactory) {
            this.itemFactory = itemFactory;
            return this;
        }

        public <E extends TileEntity> MiniBlock<T> withTileEntity(Supplier<E> factory) {
            return this.withTileEntity((Supplier<T> block) -> new TileEntityType(factory, (Set)ImmutableSet.of(block.get()), null));
        }

        public <E extends TileEntity> MiniBlock<T> withTileEntity(Supplier<E> factory, Function<Supplier<T>, Collection<Supplier<? extends Block>>> validBlocks) {
            return this.withTileEntity((Supplier<T> block) -> new TileEntityType(factory, (Set)ImmutableSet.copyOf(((Collection)validBlocks.apply((Supplier)block)).stream().map(Supplier::get).iterator()), null));
        }

        public MiniBlock<T> withTileEntity(Function<Supplier<T>, ? extends TileEntityType<?>> tileEntityFactory) {
            this.tileEntityFactory = tileEntityFactory;
            return this;
        }

        @Override
        public RegistryObject<T> defer() {
            RegistryObject block = super.defer();
            if (this.itemFactory != null) {
                ((DeferredRegister)RegSitter.this.ITEMS.get()).register(this.name, () -> this.itemFactory.apply((Supplier<RegistryObject>)block));
            }
            if (this.tileEntityFactory != null) {
                ((DeferredRegister)RegSitter.this.TILE_ENTITIES.get()).register(this.name, () -> this.tileEntityFactory.apply((Supplier<RegistryObject>)block));
            }
            return block;
        }
    }
}

