/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.sworddisplay.blocks;

import com.sofodev.sworddisplay.blocks.SwordDisplayTile;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SwordItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.registries.ForgeRegistries;

public class SwordDisplayBlock
extends Block {
    private static final List<Item> SPECIAL_ITEMS = Stream.of("tconstruct:broadsword", "tconstruct:cleaver", "tconstruct:rapier", "draconicevolution:wyvern_sword", "draconicevolution:draconic_sword", "tconstruct:longsword", "projecte:item.pe_dm_sword", "projecte:item.pe_rm_sword").map(SwordDisplayBlock::getItem).collect(Collectors.toList());
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    protected static final VoxelShape VOXEL = VoxelShapes.func_197878_a((VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.func_208617_a((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)5.0, (double)14.0), (IBooleanFunction)IBooleanFunction.field_223244_o_);

    public SwordDisplayBlock(Block.Properties properties) {
        super(properties.func_200948_a(10.0f, 1000.0f).harvestLevel(1).harvestTool(ToolType.PICKAXE));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH));
    }

    public SwordDisplayBlock() {
        this(Block.Properties.func_200945_a((Material)Material.field_151592_s));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VOXEL;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VOXEL;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof SwordDisplayTile) {
            tileentity.func_145829_t();
            worldIn.func_175690_a(pos, tileentity);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        TileEntity te = world.func_175625_s(pos);
        if (!world.field_72995_K && te instanceof SwordDisplayTile) {
            SwordDisplayTile displayTile = (SwordDisplayTile)te;
            if (player.func_225608_bj_()) {
                if (player.func_184600_cs() == Hand.MAIN_HAND && player.func_184614_ca().func_190926_b()) {
                    ItemStack toDrop = displayTile.getSword().func_77946_l();
                    displayTile.setSword(ItemStack.field_190927_a);
                    player.func_71019_a(toDrop, false);
                }
            } else {
                boolean isSword;
                ItemStack stack = player.func_184586_b(hand);
                boolean bl = isSword = stack.func_77973_b() instanceof SwordItem || this.anyMatch(stack, SPECIAL_ITEMS);
                if (hand == Hand.MAIN_HAND && displayTile.getSword().func_190926_b() && isSword) {
                    ItemStack copy = stack.func_77946_l();
                    displayTile.setSword(copy);
                    stack.func_190918_g(1);
                }
            }
        }
        return ActionResultType.SUCCESS;
    }

    public boolean anyMatch(ItemStack stack, List<Item> items) {
        return items.stream().anyMatch(item -> stack.func_77973_b() == item);
    }

    public static Item getItem(String name) {
        return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(name));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        ItemStack itemstack = super.getPickBlock(state, target, world, pos, player);
        SwordDisplayTile tileTrophy = (SwordDisplayTile)world.func_175625_s(pos);
        CompoundNBT nbttagcompound = tileTrophy.saveToNbt(new CompoundNBT());
        tileTrophy.func_70296_d();
        if (!nbttagcompound.isEmpty()) {
            itemstack.func_77983_a("BlockEntityTag", (INBT)nbttagcompound);
        }
        return itemstack;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof SwordDisplayTile) {
                InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)((SwordDisplayTile)tileentity).getSword().func_77946_l());
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState state, World world, BlockPos pos) {
        SwordDisplayTile displayTile;
        ItemStack stack;
        TileEntity te = world.func_175625_s(pos);
        if (!world.field_72995_K && te instanceof SwordDisplayTile && !(stack = (displayTile = (SwordDisplayTile)te).getSword()).func_190926_b()) {
            return this.calculateOutput(stack);
        }
        return 0;
    }

    private int calculateOutput(ItemStack stack) {
        if (stack.func_77951_h()) {
            int x = stack.func_77958_k() / (stack.func_77958_k() - stack.func_77952_i());
            x = x > 15 ? 14 : (x == 15 ? 13 : x);
            return 15 / x;
        }
        return 15;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new SwordDisplayTile();
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f());
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return facing.func_176740_k().func_176722_c() ? stateIn : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return super.func_185471_a(state, mirrorIn);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING});
    }

    public boolean func_220081_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return false;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_220080_a(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return 1.0f;
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    public boolean func_229869_c_(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return false;
    }

    public boolean func_220067_a(BlockState state, IBlockReader worldIn, BlockPos pos, EntityType<?> type) {
        return false;
    }
}

