/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.concurrent.batch;

import com.terraforged.core.concurrent.Resource;
import com.terraforged.core.concurrent.batch.BatchTask;
import com.terraforged.core.concurrent.batch.Batcher;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;

public class TaskBatcher
implements Batcher,
BatchTask.Notifier,
Resource<Batcher> {
    private final Executor executor;
    private final Object lock = new Object();
    private final AtomicInteger count = new AtomicInteger();
    private int size;
    private int submitted;

    public TaskBatcher(Executor executor) {
        this.executor = executor;
    }

    @Override
    public Batcher get() {
        return this;
    }

    @Override
    public boolean isOpen() {
        return this.submitted > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markDone() {
        if (this.count.incrementAndGet() >= this.size) {
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }
    }

    @Override
    public void size(int size) {
        this.count.set(0);
        this.size = size;
        this.submitted = 0;
    }

    @Override
    public void submit(Runnable task) {
    }

    @Override
    public void submit(BatchTask task) {
        if (this.submitted < this.size) {
            ++this.submitted;
            task.setNotifier(this);
            this.executor.execute(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.submitted <= 0) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            try {
                this.lock.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

