/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.concurrent.cache;

import com.terraforged.core.concurrent.cache.ExpiringEntry;
import com.terraforged.core.concurrent.cache.SynchronizedLongMap;
import com.terraforged.core.concurrent.thread.ThreadPool;
import com.terraforged.core.concurrent.thread.ThreadPools;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.LongFunction;

public class Cache<V extends ExpiringEntry>
implements Runnable {
    private final long expireMS;
    private final long intervalMS;
    private final SynchronizedLongMap<V> map;
    private final ThreadPool threadPool = ThreadPools.getUtilPool();
    private volatile long timestamp = 0L;

    public Cache(long expireTime, long interval, TimeUnit unit) {
        this(200, expireTime, interval, unit);
    }

    public Cache(int capacity, long expireTime, long interval, TimeUnit unit) {
        this.expireMS = unit.toMillis(expireTime);
        this.intervalMS = unit.toMillis(interval);
        this.map = new SynchronizedLongMap(capacity);
    }

    public void remove(long key) {
        this.map.remove(key, ExpiringEntry::close);
    }

    public V get(long key) {
        return (V)((ExpiringEntry)this.map.get(key));
    }

    public V computeIfAbsent(long key, LongFunction<V> func) {
        ExpiringEntry v = (ExpiringEntry)this.map.computeIfAbsent(key, func);
        this.queueUpdate();
        return (V)v;
    }

    public <T> T map(long key, LongFunction<V> func, Function<V, T> mapper) {
        T t = this.map.map(key, func, mapper);
        this.queueUpdate();
        return t;
    }

    private void queueUpdate() {
        long now = System.currentTimeMillis();
        if (now - this.timestamp > this.intervalMS) {
            this.timestamp = now;
            this.threadPool.submit(this);
        }
    }

    @Override
    public void run() {
        long now = this.timestamp;
        this.map.removeIf(val -> {
            if (now - val.getTimestamp() > this.expireMS) {
                val.close();
                return true;
            }
            return false;
        });
    }
}

