/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.concurrent.cache;

import com.terraforged.core.concurrent.cache.ExpiringEntry;
import com.terraforged.core.concurrent.thread.ThreadPool;
import java.util.concurrent.Callable;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import java.util.function.Function;

public class CacheEntry<T>
implements ExpiringEntry {
    private volatile long timestamp;
    private volatile T value = null;
    private final Future<T> task;

    public CacheEntry(Future<T> task) {
        this.task = task;
        this.timestamp = System.currentTimeMillis();
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void close() {
        if (this.value instanceof AutoCloseable) {
            try {
                ((AutoCloseable)this.value).close();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isDone() {
        return this.task.isDone();
    }

    public T get() {
        this.timestamp = System.currentTimeMillis();
        if (this.task instanceof ForkJoinTask) {
            this.value = ((ForkJoinTask)this.task).join();
            return this.value;
        }
        try {
            this.value = this.task.get();
            return this.value;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public <V> CacheEntry<V> then(ThreadPool executor, Function<T, V> function) {
        return CacheEntry.supplyAsync(() -> function.apply(this.get()), executor);
    }

    public static <T> CacheEntry<T> supply(Future<T> task) {
        return new CacheEntry<T>(task);
    }

    public static <T> CacheEntry<T> supplyAsync(Callable<T> callable, ThreadPool executor) {
        return new CacheEntry<T>(executor.submit(callable));
    }
}

