/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.serialization.serializer;

import com.terraforged.core.serialization.annotation.Comment;
import com.terraforged.core.serialization.annotation.Limit;
import com.terraforged.core.serialization.annotation.Name;
import com.terraforged.core.serialization.annotation.NoName;
import com.terraforged.core.serialization.annotation.Range;
import com.terraforged.core.serialization.annotation.Serializable;
import com.terraforged.core.serialization.serializer.Writer;
import com.terraforged.core.util.NameUtil;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class Serializer {
    public static void serialize(Object object, Writer writer) throws IllegalAccessException {
        Serializer.serialize(object, writer, true);
    }

    public static void serialize(Object object, Writer writer, boolean meta) throws IllegalAccessException {
        Serializer.serialize(object, writer, "", meta);
    }

    public static void serialize(Object object, Writer writer, String parentId, boolean meta) throws IllegalAccessException {
        if (object.getClass().isArray()) {
            writer.beginArray();
            int length = Array.getLength(object);
            for (int i = 0; i < length; ++i) {
                Object element = Array.get(object, i);
                Serializer.serialize(element, writer);
            }
            writer.endArray();
        } else if (!object.getClass().isPrimitive()) {
            int order = 0;
            writer.beginObject();
            for (Field field : object.getClass().getFields()) {
                if (!Serializer.isSerializable(field)) continue;
                field.setAccessible(true);
                Serializer.write(object, field, order, writer, parentId, meta);
                ++order;
            }
            writer.endObject();
        }
    }

    private static void write(Object object, Field field, int order, Writer writer, String parentId, boolean meta) throws IllegalAccessException {
        if (field.getType() == Integer.TYPE) {
            writer.name(field.getName()).value((Integer)field.get(object));
            Serializer.writeMeta(field, order, writer, parentId, meta);
            return;
        }
        if (field.getType() == Float.TYPE) {
            writer.name(field.getName()).value(((Float)field.get(object)).floatValue());
            Serializer.writeMeta(field, order, writer, parentId, meta);
            return;
        }
        if (field.getType() == String.class) {
            writer.name(field.getName()).value((String)field.get(object));
            Serializer.writeMeta(field, order, writer, parentId, meta);
            return;
        }
        if (field.getType() == Boolean.TYPE) {
            writer.name(field.getName()).value("" + field.get(object));
            Serializer.writeMeta(field, order, writer, parentId, meta);
            return;
        }
        if (field.getType().isEnum()) {
            writer.name(field.getName()).value(((Enum)field.get(object)).name());
            Serializer.writeMeta(field, order, writer, parentId, meta);
            return;
        }
        if (field.getType().isArray()) {
            if (field.getType().getComponentType().isAnnotationPresent(Serializable.class)) {
                writer.name(field.getName());
                Serializer.serialize(field.get(object), writer, Serializer.getKeyName(parentId, field), meta);
                Serializer.writeMeta(field, order, writer, parentId, meta);
            }
            return;
        }
        if (field.getType().isAnnotationPresent(Serializable.class)) {
            writer.name(field.getName());
            String parent = Serializer.getKeyName(parentId, field);
            Serializer.serialize(field.get(object), writer, parent, meta);
            Serializer.writeMeta(field, order, writer, parentId, meta);
        }
    }

    private static void writeMeta(Field field, int order, Writer writer, String parentId, boolean meta) {
        Limit limit;
        NoName noName;
        Comment comment;
        if (!meta) {
            return;
        }
        writer.name("#" + field.getName()).beginObject();
        writer.name("order").value(order);
        writer.name("key").value(Serializer.getKeyName(parentId, field));
        writer.name("display").value(Serializer.getDisplayName(field));
        Range range = field.getAnnotation(Range.class);
        if (range != null) {
            if (field.getType() == Integer.TYPE) {
                writer.name("min").value((int)range.min());
                writer.name("max").value((int)range.max());
            } else {
                writer.name("min").value(range.min());
                writer.name("max").value(range.max());
            }
        }
        if ((comment = field.getAnnotation(Comment.class)) != null) {
            writer.name("comment");
            writer.value(Serializer.getComment(comment));
        }
        if ((noName = field.getAnnotation(NoName.class)) != null) {
            writer.name("noname");
            writer.value("true");
        }
        if ((limit = field.getAnnotation(Limit.class)) != null) {
            writer.name("limit_lower");
            writer.value(limit.lower());
            writer.name("limit_upper");
            writer.value(limit.upper());
            writer.name("pad");
            writer.value(limit.pad());
        }
        if (field.getType() == Boolean.TYPE) {
            writer.name("options");
            writer.beginArray();
            writer.value("true");
            writer.value("false");
            writer.endArray();
        }
        if (field.getType().isEnum()) {
            writer.name("options");
            writer.beginArray();
            for (Enum o : field.getType().asSubclass(Enum.class).getEnumConstants()) {
                writer.value(o.name());
            }
            writer.endArray();
        }
        writer.endObject();
    }

    private static String getDisplayName(Field field) {
        Name nameMeta = field.getAnnotation(Name.class);
        String name = nameMeta == null ? field.getName() : nameMeta.value();
        return NameUtil.toDisplayName(name);
    }

    private static String getKeyName(String parent, Field field) {
        Name nameMeta = field.getAnnotation(Name.class);
        String name = nameMeta == null ? field.getName() : nameMeta.value();
        return NameUtil.toTranslationKey(parent, name);
    }

    private static String getComment(Comment comment) {
        return String.join((CharSequence)"\n", comment.value());
    }

    protected static boolean isSerializable(Field field) {
        int modifiers = field.getModifiers();
        return Modifier.isPublic(modifiers) && !Modifier.isFinal(modifiers) && !Modifier.isStatic(modifiers) && !Modifier.isTransient(modifiers);
    }
}

