/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.tile;

import com.terraforged.core.cell.Cell;
import com.terraforged.core.concurrent.Disposable;
import com.terraforged.core.concurrent.Resource;
import com.terraforged.core.concurrent.batch.Batcher;
import com.terraforged.core.concurrent.cache.SafeCloseable;
import com.terraforged.core.filter.Filterable;
import com.terraforged.core.tile.Size;
import com.terraforged.core.tile.chunk.ChunkBatchTask;
import com.terraforged.core.tile.chunk.ChunkGenTask;
import com.terraforged.core.tile.chunk.ChunkReader;
import com.terraforged.core.tile.chunk.ChunkWriter;
import com.terraforged.core.tile.gen.TileResources;
import com.terraforged.world.heightmap.Heightmap;
import com.terraforged.world.rivermap.Rivermap;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

public class Tile
implements Disposable,
SafeCloseable {
    private final int regionX;
    private final int regionZ;
    private final int chunkX;
    private final int chunkZ;
    private final int blockX;
    private final int blockZ;
    private final int border;
    private final int chunkCount;
    private final Size blockSize;
    private final Size chunkSize;
    private final Cell[] blocks;
    private final GenChunk[] chunks;
    private final Resource<Cell[]> blockResource;
    private final Resource<GenChunk[]> chunkResource;
    private final AtomicInteger active = new AtomicInteger();
    private final AtomicInteger disposed = new AtomicInteger();
    private final Disposable.Listener<Tile> listener;

    public Tile(int regionX, int regionZ, int size, int borderChunks, TileResources resources, Disposable.Listener<Tile> listener) {
        this.regionX = regionX;
        this.regionZ = regionZ;
        this.listener = listener;
        this.chunkX = regionX << size;
        this.chunkZ = regionZ << size;
        this.blockX = Size.chunkToBlock(this.chunkX);
        this.blockZ = Size.chunkToBlock(this.chunkZ);
        this.border = borderChunks;
        this.chunkSize = Size.chunks(size, borderChunks);
        this.blockSize = Size.blocks(size, borderChunks);
        this.chunkCount = this.chunkSize.size * this.chunkSize.size;
        this.blockResource = resources.blocks.get(this.blockSize.arraySize);
        this.chunkResource = resources.chunks.get(this.chunkSize.arraySize);
        this.blocks = this.blockResource.get();
        this.chunks = this.chunkResource.get();
    }

    @Override
    public void dispose() {
        if (this.disposed.incrementAndGet() >= this.chunkCount) {
            this.listener.onDispose(this);
        }
    }

    @Override
    public void close() {
        if (this.active.compareAndSet(0, -1)) {
            if (this.blockResource.isOpen()) {
                for (Cell cell : this.blocks) {
                    if (cell == null) continue;
                    cell.reset();
                }
                this.blockResource.close();
            }
            if (this.chunkResource.isOpen()) {
                Arrays.fill(this.chunks, null);
                this.chunkResource.close();
            }
        }
    }

    public long getRegionId() {
        return Tile.getRegionId(this.getRegionX(), this.getRegionZ());
    }

    public int getRegionX() {
        return this.regionX;
    }

    public int getRegionZ() {
        return this.regionZ;
    }

    public int getBlockX() {
        return this.blockX;
    }

    public int getBlockZ() {
        return this.blockZ;
    }

    public int getOffsetChunks() {
        return this.border;
    }

    public int getChunkCount() {
        return this.chunks.length;
    }

    public int getBlockCount() {
        return this.blocks.length;
    }

    public Size getChunkSize() {
        return this.chunkSize;
    }

    public Size getBlockSize() {
        return this.blockSize;
    }

    public Filterable filterable() {
        return new FilterRegion();
    }

    public Cell getCell(int blockX, int blockZ) {
        int relBlockX = this.blockSize.border + this.blockSize.mask(blockX);
        int relBlockZ = this.blockSize.border + this.blockSize.mask(blockZ);
        int index = this.blockSize.indexOf(relBlockX, relBlockZ);
        return this.blocks[index];
    }

    public Cell getRawCell(int blockX, int blockZ) {
        int index = this.blockSize.indexOf(blockX, blockZ);
        return this.blocks[index];
    }

    public ChunkWriter getChunkWriter(int chunkX, int chunkZ) {
        int index = this.chunkSize.indexOf(chunkX, chunkZ);
        return this.computeChunk(index, chunkX, chunkZ);
    }

    public ChunkReader getChunk(int chunkX, int chunkZ) {
        int relChunkX = this.chunkSize.border + this.chunkSize.mask(chunkX);
        int relChunkZ = this.chunkSize.border + this.chunkSize.mask(chunkZ);
        int index = this.chunkSize.indexOf(relChunkX, relChunkZ);
        return this.chunks[index].open();
    }

    public void generate(Consumer<ChunkWriter> consumer) {
        for (int cz = 0; cz < this.chunkSize.total; ++cz) {
            for (int cx = 0; cx < this.chunkSize.total; ++cx) {
                int index = this.chunkSize.indexOf(cx, cz);
                GenChunk chunk = this.computeChunk(index, cx, cz);
                consumer.accept(chunk);
            }
        }
    }

    public void generate(Heightmap heightmap) {
        Rivermap riverMap = null;
        for (int cz = 0; cz < this.chunkSize.total; ++cz) {
            for (int cx = 0; cx < this.chunkSize.total; ++cx) {
                int index = this.chunkSize.indexOf(cx, cz);
                GenChunk chunk = this.computeChunk(index, cx, cz);
                for (int dz = 0; dz < 16; ++dz) {
                    for (int dx = 0; dx < 16; ++dx) {
                        float x = chunk.getBlockX() + dx;
                        float z = chunk.getBlockZ() + dz;
                        Cell cell = chunk.genCell(dx, dz);
                        heightmap.applyBase(cell, x, z);
                        riverMap = Rivermap.get(cell, riverMap, heightmap);
                        heightmap.applyRivers(cell, x, z, riverMap);
                        heightmap.applyClimate(cell, x, z);
                    }
                }
            }
        }
    }

    public void generate(Heightmap heightmap, Batcher batcher) {
        for (int cz = 0; cz < this.chunkSize.total; ++cz) {
            for (int cx = 0; cx < this.chunkSize.total; ++cx) {
                int index = this.chunkSize.indexOf(cx, cz);
                GenChunk chunk = this.computeChunk(index, cx, cz);
                batcher.submit(new ChunkGenTask(chunk, heightmap));
            }
        }
    }

    public void generate(Heightmap heightmap, float offsetX, float offsetZ, float zoom) {
        Rivermap riverMap = null;
        float translateX = offsetX - (float)this.blockSize.size * zoom / 2.0f;
        float translateZ = offsetZ - (float)this.blockSize.size * zoom / 2.0f;
        for (int cz = 0; cz < this.chunkSize.total; ++cz) {
            for (int cx = 0; cx < this.chunkSize.total; ++cx) {
                int index = this.chunkSize.indexOf(cx, cz);
                GenChunk chunk = this.computeChunk(index, cx, cz);
                for (int dz = 0; dz < 16; ++dz) {
                    for (int dx = 0; dx < 16; ++dx) {
                        float x = (float)(chunk.getBlockX() + dx) * zoom + translateX;
                        float z = (float)(chunk.getBlockZ() + dz) * zoom + translateZ;
                        Cell cell = chunk.genCell(dx, dz);
                        heightmap.applyBase(cell, x, z);
                        riverMap = Rivermap.get(cell, riverMap, heightmap);
                        heightmap.applyRivers(cell, x, z, riverMap);
                        heightmap.applyClimate(cell, x, z);
                    }
                }
            }
        }
    }

    public void generate(Heightmap heightmap, Batcher batcher, float offsetX, float offsetZ, float zoom) {
        float translateX = offsetX - (float)this.blockSize.size * zoom / 2.0f;
        float translateZ = offsetZ - (float)this.blockSize.size * zoom / 2.0f;
        batcher.size(this.chunkSize.total * this.chunkSize.total);
        for (int cz = 0; cz < this.chunkSize.total; ++cz) {
            for (int cx = 0; cx < this.chunkSize.total; ++cx) {
                int index = this.chunkSize.indexOf(cx, cz);
                GenChunk chunk = this.computeChunk(index, cx, cz);
                batcher.submit(new ChunkGenTask.Zoom(chunk, heightmap, translateX, translateZ, zoom));
            }
        }
    }

    public void generateArea(Heightmap heightmap, Batcher batcher, int batchSize) {
        int jobSize = Math.max(1, this.chunkSize.total / batchSize);
        int jobCount = this.chunkSize.total / jobSize;
        if (jobCount * jobSize < this.chunkSize.total) {
            ++jobCount;
        }
        batcher.size(jobCount * jobCount);
        for (int gz = 0; gz < jobCount; ++gz) {
            int cz = gz * jobSize;
            for (int gx = 0; gx < jobCount; ++gx) {
                int cx = gx * jobSize;
                batcher.submit(new ChunkBatchTask(cx, cz, jobSize, this, heightmap));
            }
        }
    }

    public void generateArea(Heightmap heightmap, Batcher batcher, int batchSize, float offsetX, float offsetZ, float zoom) {
        int jobSize = Math.max(1, this.chunkSize.total / batchSize);
        int jobCount = this.chunkSize.total / jobSize;
        if (jobCount * jobSize < this.chunkSize.total) {
            ++jobCount;
        }
        batcher.size(jobCount * jobCount);
        float translateX = offsetX - (float)this.blockSize.size * zoom / 2.0f;
        float translateZ = offsetZ - (float)this.blockSize.size * zoom / 2.0f;
        for (int gz = 0; gz < jobCount; ++gz) {
            int cz = gz * jobSize;
            for (int gx = 0; gx < jobCount; ++gx) {
                int cx = gx * jobSize;
                batcher.submit(new ChunkBatchTask.Zoom(cx, cz, jobSize, this, heightmap, translateX, translateZ, zoom));
            }
        }
    }

    public void iterate(Cell.Visitor visitor) {
        for (int dz = 0; dz < this.blockSize.size; ++dz) {
            int z = this.blockSize.border + dz;
            for (int dx = 0; dx < this.blockSize.size; ++dx) {
                int x = this.blockSize.border + dx;
                int index = this.blockSize.indexOf(x, z);
                Cell cell = this.blocks[index];
                visitor.visit(cell, dx, dz);
            }
        }
    }

    private GenChunk computeChunk(int index, int chunkX, int chunkZ) {
        GenChunk chunk = this.chunks[index];
        if (chunk == null) {
            this.chunks[index] = chunk = new GenChunk(chunkX, chunkZ);
        }
        return chunk;
    }

    private Cell computeCell(int index) {
        Cell cell = this.blocks[index];
        if (cell == null) {
            this.blocks[index] = cell = new Cell();
        }
        return cell;
    }

    public static long getRegionId(int regionX, int regionZ) {
        return (long)regionX & 0xFFFFFFFFL | ((long)regionZ & 0xFFFFFFFFL) << 32;
    }

    private class FilterRegion
    implements Filterable {
        private FilterRegion() {
        }

        @Override
        public Size getSize() {
            return Tile.this.blockSize;
        }

        @Override
        public Cell[] getBacking() {
            return Tile.this.blocks;
        }

        @Override
        public Cell getCellRaw(int x, int z) {
            int index = Tile.this.blockSize.indexOf(x, z);
            if (index < 0 || index >= ((Tile)Tile.this).blockSize.arraySize) {
                return Cell.empty();
            }
            return Tile.this.blocks[index];
        }
    }

    public class GenChunk
    implements ChunkReader,
    ChunkWriter {
        private final int chunkX;
        private final int chunkZ;
        private final int blockX;
        private final int blockZ;
        private final int regionBlockX;
        private final int regionBlockZ;

        private GenChunk(int regionChunkX, int regionChunkZ) {
            this.regionBlockX = regionChunkX << 4;
            this.regionBlockZ = regionChunkZ << 4;
            this.chunkX = Tile.this.chunkX + regionChunkX - Tile.this.getOffsetChunks();
            this.chunkZ = Tile.this.chunkZ + regionChunkZ - Tile.this.getOffsetChunks();
            this.blockX = this.chunkX << 4;
            this.blockZ = this.chunkZ << 4;
        }

        public GenChunk open() {
            Tile.this.active.getAndIncrement();
            return this;
        }

        @Override
        public void close() {
            Tile.this.active.decrementAndGet();
        }

        @Override
        public void dispose() {
            Tile.this.dispose();
        }

        @Override
        public int getChunkX() {
            return this.chunkX;
        }

        @Override
        public int getChunkZ() {
            return this.chunkZ;
        }

        @Override
        public int getBlockX() {
            return this.blockX;
        }

        @Override
        public int getBlockZ() {
            return this.blockZ;
        }

        @Override
        public Cell getCell(int blockX, int blockZ) {
            int relX = this.regionBlockX + (blockX & 0xF);
            int relZ = this.regionBlockZ + (blockZ & 0xF);
            int index = Tile.this.blockSize.indexOf(relX, relZ);
            return Tile.this.blocks[index];
        }

        @Override
        public Cell genCell(int blockX, int blockZ) {
            int relX = this.regionBlockX + (blockX & 0xF);
            int relZ = this.regionBlockZ + (blockZ & 0xF);
            int index = Tile.this.blockSize.indexOf(relX, relZ);
            return Tile.this.computeCell(index);
        }
    }
}

