/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.tile.gen;

import com.terraforged.core.concurrent.Disposable;
import com.terraforged.core.concurrent.cache.Cache;
import com.terraforged.core.concurrent.cache.CacheEntry;
import com.terraforged.core.tile.Tile;
import com.terraforged.core.tile.chunk.ChunkReader;
import com.terraforged.core.tile.gen.TileGenerator;
import java.util.concurrent.TimeUnit;
import java.util.function.LongFunction;

public class TileCache
implements Disposable.Listener<Tile> {
    private final boolean queuing;
    private final TileGenerator generator;
    private final Cache<CacheEntry<Tile>> cache;
    private final LongFunction<CacheEntry<Tile>> syncGetter;
    private final LongFunction<CacheEntry<Tile>> asyncGetter;

    public TileCache(boolean queueNeighbours, TileGenerator generator) {
        this.generator = generator;
        this.syncGetter = this.syncGetter();
        this.asyncGetter = this.asyncGetter();
        this.queuing = queueNeighbours;
        this.cache = new Cache(60L, 30L, TimeUnit.SECONDS);
        generator.setListener(this);
    }

    @Override
    public void onDispose(Tile tile) {
        this.cache.remove(tile.getRegionId());
    }

    public int chunkToRegion(int coord) {
        return this.generator.chunkToRegion(coord);
    }

    public ChunkReader getChunk(int chunkX, int chunkZ) {
        int regionX = this.generator.chunkToRegion(chunkX);
        int regionZ = this.generator.chunkToRegion(chunkZ);
        long regionId = Tile.getRegionId(regionX, regionZ);
        return this.cache.map(regionId, this.syncGetter, entry -> ((Tile)entry.get()).getChunk(chunkX, chunkZ));
    }

    public Tile getRegion(int regionX, int regionZ) {
        Tile tile = this.getEntry(regionX, regionZ).get();
        if (this.queuing) {
            this.queueNeighbours(regionX, regionZ);
        }
        return tile;
    }

    public Tile getIfPresent(int regionX, int regionZ) {
        CacheEntry<Tile> entry = this.cache.get(Tile.getRegionId(regionX, regionZ));
        if (entry == null || !entry.isDone()) {
            return null;
        }
        return entry.get();
    }

    public CacheEntry<Tile> getEntry(int regionX, int regionZ) {
        return this.cache.computeIfAbsent(Tile.getRegionId(regionX, regionZ), this.syncGetter);
    }

    public CacheEntry<Tile> queueRegion(int regionX, int regionZ) {
        return this.cache.computeIfAbsent(Tile.getRegionId(regionX, regionZ), this.asyncGetter);
    }

    private LongFunction<CacheEntry<Tile>> syncGetter() {
        return id -> this.generator.getSync((int)id, (int)(id >> 32));
    }

    private LongFunction<CacheEntry<Tile>> asyncGetter() {
        return id -> this.generator.getAsync((int)id, (int)(id >> 32));
    }

    private void queueNeighbours(int rx, int rz) {
        for (int dz = -1; dz <= 1; ++dz) {
            for (int dx = 0; dx <= 1; ++dx) {
                if (dx == 0 && dz == 0) continue;
                this.queueRegion(rx + dx, rz + dz);
            }
        }
    }
}

