/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.fm;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.types.DynamicOps;
import com.mojang.datafixers.types.JsonOps;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class FeatureMatcher
implements Predicate<ConfiguredFeature<?, ?>> {
    private final JsonElement[] rules;

    private FeatureMatcher(JsonElement[] rules) {
        this.rules = rules;
    }

    @Override
    public boolean test(ConfiguredFeature<?, ?> feature) {
        try {
            return this.test((JsonElement)feature.func_222735_a((DynamicOps)JsonOps.INSTANCE).getValue());
        }
        catch (Throwable t) {
            return false;
        }
    }

    @Override
    public boolean test(JsonElement element) {
        return FeatureMatcher.test(element, this.rules, new boolean[this.rules.length]);
    }

    private static boolean test(JsonElement element, JsonElement[] rules, boolean[] matches) {
        if (element.isJsonObject()) {
            for (Map.Entry e : element.getAsJsonObject().entrySet()) {
                if (!FeatureMatcher.test((JsonElement)e.getValue(), rules, matches)) continue;
                return true;
            }
        } else if (element.isJsonArray()) {
            for (JsonElement e : element.getAsJsonArray()) {
                if (!FeatureMatcher.test(e, rules, matches)) continue;
                return true;
            }
        } else {
            for (int i = 0; i < rules.length; ++i) {
                if (!rules[i].isJsonNull() && !rules[i].equals(element)) continue;
                matches[i] = true;
            }
        }
        return FeatureMatcher.isMatch(matches);
    }

    private static boolean isMatch(boolean[] matches) {
        for (boolean b : matches) {
            if (b) continue;
            return false;
        }
        return true;
    }

    public static FeatureMatcher of(Object ... values) {
        JsonElement[] rules = new JsonElement[values.length];
        for (int i = 0; i < rules.length; ++i) {
            rules[i] = FeatureMatcher.toJson(rules[i]);
        }
        return new FeatureMatcher(rules);
    }

    private static JsonElement toJson(Object o) {
        if (o instanceof IForgeRegistryEntry) {
            return new JsonPrimitive(((IForgeRegistryEntry)o).getRegistryName().toString());
        }
        if (o instanceof String) {
            return new JsonPrimitive((String)o);
        }
        if (o instanceof Long) {
            return new JsonPrimitive((Number)((Long)o));
        }
        if (o instanceof Integer) {
            return new JsonPrimitive((Number)((Integer)o));
        }
        if (o instanceof Double) {
            return new JsonPrimitive((Number)((Double)o));
        }
        if (o instanceof Float) {
            return new JsonPrimitive((Number)Float.valueOf(((Float)o).floatValue()));
        }
        if (o instanceof Boolean) {
            return new JsonPrimitive(Boolean.valueOf((Boolean)o));
        }
        return JsonNull.INSTANCE;
    }
}

