/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.fm.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.terraforged.fm.FeatureManager;
import com.terraforged.fm.data.FolderDataPackFinder;
import com.terraforged.fm.data.ModDataPackFinder;
import com.terraforged.fm.data.ResourceVisitor;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.function.Predicate;
import net.minecraft.resources.IPackFinder;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.ResourcePackList;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.resources.SimpleReloadableResourceManager;
import net.minecraft.util.ResourceLocation;

public class DataManager
implements AutoCloseable {
    public static final Predicate<String> ANY = s -> true;
    public static final Predicate<String> NBT = s -> s.endsWith(".nbt");
    public static final Predicate<String> JSON = s -> s.endsWith(".json");
    private final ResourcePackList<ResourcePackInfo> packList;
    private final IResourceManager resourceManager;

    public DataManager(IResourceManager resourceManager, ResourcePackList<ResourcePackInfo> packList) {
        this.resourceManager = resourceManager;
        this.packList = packList;
    }

    @Override
    public void close() {
        this.packList.close();
    }

    public IResource getResource(ResourceLocation location) throws IOException {
        return this.resourceManager.func_199002_a(location);
    }

    public void forEach(String path, Predicate<String> matcher, ResourceVisitor<InputStream> consumer) {
        FeatureManager.LOG.debug("Input path: {}", (Object)path);
        for (ResourceLocation location : this.resourceManager.func_199003_a(path, matcher)) {
            FeatureManager.LOG.debug(" Location: {}", (Object)location);
            try {
                IResource resource = this.getResource(location);
                Throwable throwable = null;
                try {
                    if (resource == null) continue;
                    InputStream inputStream = resource.func_199027_b();
                    Throwable throwable2 = null;
                    try {
                        consumer.accept(location, inputStream);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (throwable2 != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        inputStream.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (resource == null) continue;
                    if (throwable != null) {
                        try {
                            resource.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    resource.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void forEachJson(String path, ResourceVisitor<JsonElement> consumer) {
        JsonParser parser = new JsonParser();
        this.forEach(path, JSON, (location, data) -> {
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)data));
            JsonElement element = parser.parse((Reader)reader);
            consumer.accept(location, element);
        });
    }

    public static DataManager of(File dir) {
        SimpleReloadableResourceManager manager = new SimpleReloadableResourceManager(ResourcePackType.SERVER_DATA, Thread.currentThread());
        ResourcePackList packList = new ResourcePackList(ResourcePackInfo::new);
        packList.func_198982_a((IPackFinder)new ModDataPackFinder());
        packList.func_198982_a((IPackFinder)new FolderDataPackFinder(dir));
        packList.func_198983_a();
        packList.func_198978_b().stream().map(ResourcePackInfo::func_195796_e).forEach(arg_0 -> ((SimpleReloadableResourceManager)manager).func_199021_a(arg_0));
        return new DataManager((IResourceManager)manager, (ResourcePackList<ResourcePackInfo>)packList);
    }
}

