/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.fm.matcher.biome;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.registries.ForgeRegistries;

public class BiomeMatcher
implements Predicate<Biome>,
Comparable<BiomeMatcher> {
    public static final BiomeMatcher ANY = new BiomeMatcher(Collections.emptySet());
    private final Set<Biome> biomes;

    private BiomeMatcher(Set<Biome> biomes) {
        this.biomes = biomes;
    }

    @Override
    public int compareTo(BiomeMatcher o) {
        return Integer.compare(o.biomes.size(), this.biomes.size());
    }

    @Override
    public boolean test(Biome biome) {
        return this.biomes.isEmpty() || this.biomes.contains(biome);
    }

    public BiomeMatcher or(BiomeMatcher other) {
        HashSet<Biome> combined = new HashSet<Biome>();
        combined.addAll(this.biomes);
        combined.addAll(other.biomes);
        return new BiomeMatcher(combined);
    }

    public static BiomeMatcher of(Biome.Category ... types) {
        HashSet<Biome> biomes = new HashSet<Biome>();
        block0: for (Biome biome : ForgeRegistries.BIOMES) {
            for (Biome.Category category : types) {
                if (biome.func_201856_r() != category) continue;
                biomes.add(biome);
                continue block0;
            }
        }
        if (biomes.isEmpty()) {
            return ANY;
        }
        return BiomeMatcher.of(biomes);
    }

    public static BiomeMatcher of(Biome biome) {
        return new BiomeMatcher(Collections.singleton(biome));
    }

    public static BiomeMatcher of(Set<Biome> biomes) {
        return new BiomeMatcher(biomes);
    }
}

