/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.fm.modifier;

import com.google.gson.JsonObject;
import com.terraforged.fm.FeatureManager;
import com.terraforged.fm.data.DataManager;
import com.terraforged.fm.matcher.BiomeFeatureMatcher;
import com.terraforged.fm.matcher.biome.BiomeMatcher;
import com.terraforged.fm.matcher.biome.BiomeMatcherParser;
import com.terraforged.fm.matcher.feature.FeatureMatcher;
import com.terraforged.fm.matcher.feature.FeatureMatcherParser;
import com.terraforged.fm.modifier.FeatureModifiers;
import com.terraforged.fm.transformer.FeatureAppender;
import com.terraforged.fm.transformer.FeatureInjector;
import com.terraforged.fm.transformer.FeatureParser;
import com.terraforged.fm.transformer.FeatureReplacer;
import com.terraforged.fm.transformer.FeatureTransformer;
import java.util.Optional;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class FeatureModifierLoader {
    public static final Marker LOAD = MarkerManager.getMarker((String)"MODIFIERS");

    public static FeatureModifiers load(DataManager data) {
        FeatureManager.LOG.debug(LOAD, "Loading feature modifier configs");
        FeatureModifiers modifiers = new FeatureModifiers();
        data.forEachJson("features", (location, element) -> {
            if (element.isJsonObject() && FeatureModifierLoader.load(location, element.getAsJsonObject(), modifiers)) {
                FeatureManager.LOG.debug(LOAD, " Loaded modifier config: {}", (Object)location);
                return;
            }
            FeatureManager.LOG.error(LOAD, " Failed to load modifier config: {}", (Object)location);
        });
        return modifiers;
    }

    private static boolean load(ResourceLocation location, JsonObject root, FeatureModifiers modifiers) {
        Optional<BiomeMatcher> biome = BiomeMatcherParser.parse(root);
        if (!biome.isPresent()) {
            FeatureManager.LOG.error(LOAD, "  Invalid BiomeMatcher in: {}", (Object)location);
            return false;
        }
        Optional<FeatureAppender> appender = FeatureParser.parseAppender(root);
        if (appender.isPresent()) {
            BiomeFeatureMatcher biomeFeatureMatcher = new BiomeFeatureMatcher(biome.get(), FeatureMatcher.ANY);
            modifiers.getAppenders().add(biomeFeatureMatcher, appender.get());
            return true;
        }
        Optional<FeatureMatcher> matcher = FeatureMatcherParser.parse(root);
        if (!matcher.isPresent()) {
            FeatureManager.LOG.error(LOAD, "  Invalid FeatureMatcher in: {}", (Object)location);
            return false;
        }
        Optional<FeatureReplacer> replacer = FeatureParser.parseReplacer(root);
        if (replacer.isPresent()) {
            BiomeFeatureMatcher biomeFeatureMatcher = new BiomeFeatureMatcher(biome.get(), matcher.get());
            modifiers.getReplacers().add(biomeFeatureMatcher, replacer.get());
            return true;
        }
        Optional<FeatureTransformer> transformer = FeatureParser.parseTransformer(root);
        if (transformer.isPresent()) {
            BiomeFeatureMatcher biomeFeatureMatcher = new BiomeFeatureMatcher(biome.get(), matcher.get());
            modifiers.getTransformers().add(biomeFeatureMatcher, transformer.get());
            return true;
        }
        Optional<FeatureInjector> injector = FeatureParser.parseInjector(root);
        if (injector.isPresent()) {
            BiomeFeatureMatcher biomeFeatureMatcher = new BiomeFeatureMatcher(biome.get(), matcher.get());
            modifiers.getInjectors().add(biomeFeatureMatcher, injector.get());
            return true;
        }
        FeatureManager.LOG.error(LOAD, "  Invalid Replacer/Transformer in: {}", (Object)location);
        return false;
    }
}

