/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.fm.template;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.List;
import java.util.Map;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.feature.structure.Structure;

public class StructureUtils {
    public static final List<Structure<?>> SURFACE_STRUCTURES = ImmutableList.of((Object)Structure.field_214550_p, (Object)Structure.field_202331_i, (Object)Structure.field_214536_b, (Object)Structure.field_202334_l, (Object)Structure.field_202333_k, (Object)Structure.field_202332_j, (Object)Structure.field_202330_h);

    public static boolean hasOvergroundStructure(IChunk chunk) {
        Map references = chunk.func_201604_d();
        for (Structure<?> structure : SURFACE_STRUCTURES) {
            LongSet refs = (LongSet)references.get(structure.func_143025_a());
            if (refs == null || refs.size() <= 0) continue;
            return true;
        }
        return false;
    }

    public static boolean hasStructure(IChunk chunk, Structure<?> structure) {
        LongSet refs = (LongSet)chunk.func_201604_d().get(structure.func_143025_a());
        return refs != null && refs.size() > 0;
    }
}

