/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.fm.template.feature;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonObject;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import com.terraforged.fm.template.PasteConfig;
import com.terraforged.fm.template.Template;
import com.terraforged.fm.template.TemplateLoader;
import com.terraforged.fm.template.TemplateManager;
import com.terraforged.fm.template.decorator.DecoratorConfig;
import com.terraforged.fm.template.type.FeatureType;
import com.terraforged.fm.template.type.FeatureTypes;
import com.terraforged.fm.util.Json;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.feature.IFeatureConfig;

public class TemplateFeatureConfig
implements IFeatureConfig {
    public static final TemplateFeatureConfig NONE = new TemplateFeatureConfig();
    public final ResourceLocation name;
    public final FeatureType type;
    public final PasteConfig paste;
    public final List<Template> templates;
    public final DecoratorConfig<?> decorator;

    private TemplateFeatureConfig() {
        this.name = new ResourceLocation("fm", "none");
        this.type = FeatureTypes.ANY;
        this.paste = PasteConfig.DEFAULT;
        this.templates = Collections.emptyList();
        this.decorator = null;
    }

    public TemplateFeatureConfig(ResourceLocation name, FeatureType type, PasteConfig paste, List<Template> templates, DecoratorConfig<?> decorator) {
        this.name = name;
        this.type = type;
        this.paste = paste;
        this.templates = templates;
        this.decorator = decorator;
        type.register(name);
    }

    public <T> Dynamic<T> func_214634_a(DynamicOps<T> ops) {
        return new Dynamic(ops, ops.createMap((Map)ImmutableMap.of((Object)ops.createString("template"), (Object)ops.createString(this.name + ""))));
    }

    public static TemplateFeatureConfig deserialize(Dynamic<?> dynamic) {
        ResourceLocation name = new ResourceLocation(dynamic.get("template").asString(""));
        return TemplateManager.getInstance().getTemplateConfig(name);
    }

    public static TemplateFeatureConfig parse(TemplateLoader loader, JsonObject root) {
        ResourceLocation name = new ResourceLocation(Json.getString("name", root, ""));
        FeatureType type = FeatureTypes.getType(Json.getString("type", root, ""));
        PasteConfig paste = PasteConfig.parse(root.getAsJsonObject("config"));
        DecoratorConfig<?> decorator = DecoratorConfig.parse(type.getDecorator(), root.getAsJsonObject("decorators"));
        List<Template> templates = loader.load(name.func_110624_b(), root.getAsJsonArray("paths"));
        return new TemplateFeatureConfig(name, type, paste, templates, decorator);
    }
}

