/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.fm.template.type;

import com.terraforged.fm.matcher.feature.FeatureMatcher;
import com.terraforged.fm.template.decorator.Decorator;
import com.terraforged.fm.template.feature.Placement;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;

public class FeatureType {
    private final String name;
    private final Placement placement;
    private final Decorator.Factory<?> decorator;
    private final List<ResourceLocation> templates = new ArrayList<ResourceLocation>();

    public FeatureType(String name, Placement placement, Decorator.Factory<?> decorator) {
        this.name = name;
        this.placement = placement;
        this.decorator = decorator;
    }

    public String getName() {
        return this.name;
    }

    public Placement getPlacement() {
        return this.placement;
    }

    public Decorator.Factory<?> getDecorator() {
        return this.decorator;
    }

    public synchronized void register(ResourceLocation template) {
        this.templates.add(template);
    }

    public synchronized void clear() {
        this.templates.clear();
    }

    public String toString() {
        return this.name;
    }

    public FeatureMatcher matcher() {
        FeatureMatcher.Builder builder = FeatureMatcher.builder();
        for (ResourceLocation template : this.templates) {
            builder.or(template);
        }
        return builder.build();
    }
}

