/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.fm.template.type;

import com.terraforged.fm.template.decorator.Decorator;
import com.terraforged.fm.template.decorator.NoDecoratorFactory;
import com.terraforged.fm.template.feature.Placement;
import com.terraforged.fm.template.type.FeatureType;
import com.terraforged.fm.template.type.tree.TreeDecoratorFactory;
import com.terraforged.fm.template.type.tree.TreePlacement;
import java.util.HashMap;
import java.util.Map;

public class FeatureTypes {
    private static final Map<String, FeatureType> types = new HashMap<String, FeatureType>();
    public static final FeatureType ANY = FeatureTypes.register("any", Placement.ANY, new NoDecoratorFactory());
    public static final FeatureType TREE = FeatureTypes.register("tree", TreePlacement.PLACEMENT, new TreeDecoratorFactory());

    public static FeatureType getType(String type) {
        return types.getOrDefault(type, ANY);
    }

    public static synchronized void clearFeatures() {
        types.values().forEach(FeatureType::clear);
    }

    private static FeatureType register(String name, Placement placement, Decorator.Factory<?> factory) {
        return FeatureTypes.register(new FeatureType(name, placement, factory));
    }

    private static FeatureType register(FeatureType type) {
        types.put(type.getName(), type);
        return type;
    }
}

