/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.biome;

import com.terraforged.api.biome.BiomeVariant;
import com.terraforged.mod.biome.Bryce;
import com.terraforged.mod.biome.ColdMarshland;
import com.terraforged.mod.biome.ColdSteppe;
import com.terraforged.mod.biome.FirForest;
import com.terraforged.mod.biome.FlowerPlains;
import com.terraforged.mod.biome.FrozenLake;
import com.terraforged.mod.biome.Lake;
import com.terraforged.mod.biome.Marshland;
import com.terraforged.mod.biome.SavannaScrub;
import com.terraforged.mod.biome.ShatteredSavannaScrub;
import com.terraforged.mod.biome.SnowyFirForest;
import com.terraforged.mod.biome.SnowyTaigaScrub;
import com.terraforged.mod.biome.Steppe;
import com.terraforged.mod.biome.StoneForest;
import com.terraforged.mod.biome.TaigaScrub;
import com.terraforged.mod.biome.WarmBeach;
import java.util.ArrayList;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModBiomes {
    private static final ArrayList<BiomeVariant> biomes = new ArrayList();
    public static final Biome BRYCE = ModBiomes.register(new Bryce());
    public static final Biome COLD_STEPPE = ModBiomes.register(new ColdSteppe());
    public static final Biome COLD_MARSHLAND = ModBiomes.register(new ColdMarshland());
    public static final Biome ERODED_PINNACLE = ModBiomes.register(new StoneForest());
    public static final Biome FIR_FOREST = ModBiomes.register(new FirForest());
    public static final Biome FLOWER_PLAINS = ModBiomes.register(new FlowerPlains());
    public static final Biome FROZEN_LAKE = ModBiomes.register(new FrozenLake());
    public static final Biome LAKE = ModBiomes.register(new Lake());
    public static final Biome MARSHLAND = ModBiomes.register(new Marshland());
    public static final Biome SAVANNA_SCRUB = ModBiomes.register(new SavannaScrub());
    public static final Biome SHATTERED_SAVANNA_SCRUB = ModBiomes.register(new ShatteredSavannaScrub());
    public static final Biome SNOWY_FIR_FOREST = ModBiomes.register(new SnowyFirForest());
    public static final Biome SNOWY_TAIGA_SCRUB = ModBiomes.register(new SnowyTaigaScrub());
    public static final Biome STEPPE = ModBiomes.register(new Steppe());
    public static final Biome TAIGA_SCRUB = ModBiomes.register(new TaigaScrub());
    public static final Biome WARM_BEACH = ModBiomes.register(new WarmBeach());

    private static Biome register(BiomeVariant biome) {
        biomes.add(biome);
        return biome;
    }

    @SubscribeEvent
    public static void register(RegistryEvent.Register<Biome> event) {
        biomes.forEach(biome -> {
            event.getRegistry().register((IForgeRegistryEntry)biome);
            biome.registerWeights();
            BiomeDictionary.makeBestGuess((Biome)biome);
            BiomeDictionary.addTypes((Biome)biome, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.OVERWORLD});
            if (BiomeDictionary.getTypes((Biome)biome.getBase()).contains(BiomeDictionary.Type.RARE)) {
                BiomeDictionary.addTypes((Biome)biome, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.RARE});
            }
        });
        biomes.clear();
        biomes.trimToSize();
    }
}

