/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.biome.map;

import com.terraforged.mod.biome.map.BiomeMap;
import com.terraforged.mod.biome.map.SimpleBiomeMap;
import com.terraforged.mod.biome.provider.BiomeHelper;
import com.terraforged.world.biome.BiomeType;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.world.biome.Biome;

public class BiomeMapBuilder
implements BiomeMap.Builder {
    protected final Map<Biome.TempCategory, List<Biome>> rivers = new HashMap<Biome.TempCategory, List<Biome>>();
    protected final Map<Biome.TempCategory, List<Biome>> lakes = new HashMap<Biome.TempCategory, List<Biome>>();
    protected final Map<Biome.TempCategory, List<Biome>> coasts = new HashMap<Biome.TempCategory, List<Biome>>();
    protected final Map<Biome.TempCategory, List<Biome>> beaches = new HashMap<Biome.TempCategory, List<Biome>>();
    protected final Map<Biome.TempCategory, List<Biome>> oceans = new HashMap<Biome.TempCategory, List<Biome>>();
    protected final Map<Biome.TempCategory, List<Biome>> deepOceans = new HashMap<Biome.TempCategory, List<Biome>>();
    protected final Map<Biome.TempCategory, List<Biome>> mountains = new HashMap<Biome.TempCategory, List<Biome>>();
    protected final Map<Biome.TempCategory, List<Biome>> wetlands = new HashMap<Biome.TempCategory, List<Biome>>();
    protected final Map<BiomeType, List<Biome>> map = new EnumMap<BiomeType, List<Biome>>(BiomeType.class);
    private final Function<BiomeMapBuilder, BiomeMap> constructor;

    BiomeMapBuilder(Function<BiomeMapBuilder, BiomeMap> constructor) {
        this.constructor = constructor;
    }

    @Override
    public BiomeMapBuilder addOcean(Biome biome, int count) {
        Biome.TempCategory category = BiomeHelper.getTempCategory(biome);
        if (biome.func_185355_j() < -1.0f) {
            this.add(this.deepOceans.computeIfAbsent(category, c -> new ArrayList()), biome, count);
        } else {
            this.add(this.oceans.computeIfAbsent(category, c -> new ArrayList()), biome, count);
        }
        return this;
    }

    @Override
    public BiomeMap.Builder addBeach(Biome biome, int count) {
        Biome.TempCategory category = BiomeHelper.getTempCategory(biome);
        this.add(this.beaches.computeIfAbsent(category, c -> new ArrayList()), biome, count);
        return this;
    }

    @Override
    public BiomeMap.Builder addCoast(Biome biome, int count) {
        Biome.TempCategory category = BiomeHelper.getTempCategory(biome);
        this.add(this.coasts.computeIfAbsent(category, c -> new ArrayList()), biome, count);
        return this;
    }

    @Override
    public BiomeMapBuilder addRiver(Biome biome, int count) {
        Biome.TempCategory category = BiomeHelper.getTempCategory(biome);
        this.add(this.rivers.computeIfAbsent(category, c -> new ArrayList()), biome, count);
        return this;
    }

    @Override
    public BiomeMapBuilder addLake(Biome biome, int count) {
        Biome.TempCategory category = BiomeHelper.getTempCategory(biome);
        this.add(this.lakes.computeIfAbsent(category, c -> new ArrayList()), biome, count);
        return this;
    }

    @Override
    public BiomeMapBuilder addWetland(Biome biome, int count) {
        Biome.TempCategory category = BiomeHelper.getTempCategory(biome);
        this.add(this.wetlands.computeIfAbsent(category, c -> new ArrayList()), biome, count);
        return this;
    }

    @Override
    public BiomeMapBuilder addMountain(Biome biome, int count) {
        Biome.TempCategory category = BiomeHelper.getMountainCategory(biome);
        this.add(this.mountains.computeIfAbsent(category, c -> new ArrayList()), biome, count);
        return this;
    }

    @Override
    public BiomeMapBuilder addLand(BiomeType type, Biome biome, int count) {
        this.add(this.map.computeIfAbsent(type, t -> new ArrayList()), biome, count);
        return this;
    }

    @Override
    public BiomeMap build() {
        return this.constructor.apply(this);
    }

    private void add(List<Biome> list, Biome biome, int count) {
        for (int i = 0; i < count; ++i) {
            list.add(biome);
        }
    }

    public static BiomeMap.Builder create() {
        return new BiomeMapBuilder(SimpleBiomeMap::new);
    }
}

