/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.biome.map.set;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.terraforged.core.cell.Cell;
import com.terraforged.mod.biome.map.defaults.DefaultBiome;
import com.terraforged.mod.biome.map.set.BiomeSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class TemperatureSet
extends BiomeSet {
    public TemperatureSet(Map<Biome.TempCategory, List<Biome>> map, DefaultBiome defaultBiome) {
        super(BiomeSet.collect(map, 3, e -> e.ordinal() - 1), defaultBiome);
    }

    @Override
    public int getIndex(Cell cell) {
        if (cell.temperature < 0.25f) {
            return 0;
        }
        if (cell.temperature > 0.75f) {
            return 2;
        }
        return 1;
    }

    @Override
    public JsonElement toJson() {
        JsonObject root = new JsonObject();
        for (Biome.TempCategory temp : Biome.TempCategory.values()) {
            int index = temp.ordinal() - 1;
            if (index < 0 || index >= 3) continue;
            JsonArray array = new JsonArray();
            root.add(temp.name(), (JsonElement)array);
            Stream.of(this.getSet(index)).distinct().map(ForgeRegistryEntry::getRegistryName).map(Objects::toString).forEach(arg_0 -> ((JsonArray)array).add(arg_0));
        }
        return root;
    }
}

