/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.biome.modifier;

import com.terraforged.api.biome.modifier.BiomeModifier;
import com.terraforged.api.biome.modifier.ModifierManager;
import com.terraforged.core.cell.Cell;
import com.terraforged.mod.biome.map.BiomeMap;
import com.terraforged.mod.biome.modifier.BeachModifier;
import com.terraforged.mod.biome.modifier.CoastModifier;
import com.terraforged.mod.biome.modifier.DesertColorModifier;
import com.terraforged.mod.biome.modifier.DesertWetlandModifier;
import com.terraforged.mod.biome.modifier.MountainModifier;
import com.terraforged.mod.biome.provider.DesertBiomes;
import com.terraforged.mod.chunk.TerraContext;
import com.terraforged.world.biome.BiomeType;
import com.terraforged.world.heightmap.Levels;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.biome.Biome;

public class BiomeModifierManager
implements BiomeModifier,
ModifierManager {
    private final DesertBiomes desertBiomes;
    private final List<BiomeModifier> biomeModifiers;

    public BiomeModifierManager(TerraContext context, BiomeMap biomes) {
        this.desertBiomes = new DesertBiomes(context.materials, biomes.getAllBiomes(BiomeType.DESERT));
        ArrayList<BiomeModifier> modifiers = new ArrayList<BiomeModifier>();
        modifiers.add(new CoastModifier(biomes, context));
        modifiers.add(new DesertColorModifier(this.desertBiomes));
        modifiers.add(new BeachModifier(biomes, context));
        modifiers.add(new DesertWetlandModifier(biomes));
        modifiers.add(new MountainModifier(context, biomes));
        Collections.sort(modifiers);
        this.biomeModifiers = modifiers;
    }

    public boolean hasModifiers(Cell cell, Levels levels) {
        return cell.terrain.isOverground() || cell.terrain.isSubmerged() && cell.value > levels.water;
    }

    public DesertBiomes getDesertBiomes() {
        return this.desertBiomes;
    }

    @Override
    public void register(BiomeModifier modifier) {
        this.biomeModifiers.add(modifier);
        Collections.sort(this.biomeModifiers);
    }

    @Override
    public int priority() {
        return -1;
    }

    @Override
    public boolean test(Biome biome, Cell cell) {
        return true;
    }

    @Override
    public Biome modify(Biome biome, Cell cell, int x, int z) {
        for (BiomeModifier modifier : this.biomeModifiers) {
            if (!modifier.test(biome, cell)) continue;
            biome = modifier.modify(biome, cell, x, z);
            if (!modifier.exitEarly()) continue;
            return biome;
        }
        return biome;
    }
}

