/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.biome.modifier;

import com.terraforged.api.biome.modifier.BiomeModifier;
import com.terraforged.core.cell.Cell;
import com.terraforged.mod.biome.map.BiomeMap;
import com.terraforged.mod.biome.map.defaults.DefaultBiomes;
import com.terraforged.mod.chunk.TerraContext;
import net.minecraft.world.biome.Biome;

public class MountainModifier
implements BiomeModifier {
    public static final float MOUNTAIN_CHANCE = 0.4f;
    private final float chance;
    private final BiomeMap biomes;

    public MountainModifier(TerraContext context, BiomeMap biomes) {
        this.biomes = biomes;
        this.chance = context.terraSettings.miscellaneous.mountainBiomeUsage;
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public boolean exitEarly() {
        return true;
    }

    @Override
    public boolean test(Biome biome, Cell cell) {
        return cell.terrain.isMountain() && cell.macroNoise < this.chance;
    }

    @Override
    public Biome modify(Biome in, Cell cell, int x, int z) {
        Biome mountain = this.biomes.getMountain(cell);
        if (mountain != DefaultBiomes.NONE) {
            return mountain;
        }
        return in;
    }
}

