/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.biome.provider;

import com.terraforged.api.material.layer.LayerManager;
import com.terraforged.api.material.layer.LayerMaterial;
import com.terraforged.core.concurrent.Resource;
import com.terraforged.mod.biome.provider.BiomeHelper;
import com.terraforged.mod.material.Materials;
import com.terraforged.mod.util.DummyBlockReader;
import com.terraforged.mod.util.ListUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;

public class DesertBiomes {
    private final Set<Biome> reds;
    private final Set<Biome> whites;
    private final Set<Biome> deserts;
    private final List<Biome> redSand;
    private final List<Biome> whiteSand;
    private final LayerManager layerManager;
    private final int maxRedIndex;
    private final int maxWhiteIndex;

    public DesertBiomes(Materials materials, List<Biome> deserts) {
        LinkedList<Biome> white = new LinkedList<Biome>();
        LinkedList<Biome> red = new LinkedList<Biome>();
        try (Resource<DummyBlockReader> reader = DummyBlockReader.pooled();){
            for (Biome biome : deserts) {
                int redDist2;
                BlockState top = biome.func_203944_q().func_204108_a();
                MaterialColor color = top.func_185909_g((IBlockReader)reader.get().set(top), BlockPos.field_177992_a);
                int whiteDist2 = DesertBiomes.distance2(color, MaterialColor.field_151658_d);
                if (whiteDist2 < (redDist2 = DesertBiomes.distance2(color, MaterialColor.field_151676_q))) {
                    white.add(biome);
                    continue;
                }
                red.add(biome);
            }
        }
        this.layerManager = materials.getLayerManager();
        this.whiteSand = new ArrayList<Biome>(white);
        this.redSand = new ArrayList<Biome>(red);
        this.deserts = new HashSet<Biome>(deserts);
        this.whites = new HashSet<Biome>(white);
        this.reds = new HashSet<Biome>(red);
        this.whiteSand.sort(Comparator.comparing(BiomeHelper::getId));
        this.redSand.sort(Comparator.comparing(BiomeHelper::getId));
        this.maxRedIndex = red.size() - 1;
        this.maxWhiteIndex = white.size() - 1;
    }

    public boolean isDesert(Biome biome) {
        return this.deserts.contains(biome);
    }

    public boolean isRedDesert(Biome biome) {
        return this.reds.contains(biome);
    }

    public boolean isWhiteDesert(Biome biome) {
        return this.whites.contains(biome);
    }

    public Biome getRedDesert(float shape) {
        return ListUtils.get(this.redSand, this.maxRedIndex, shape, Biomes.field_185439_ak);
    }

    public Biome getWhiteDesert(float shape) {
        return ListUtils.get(this.whiteSand, this.maxWhiteIndex, shape, Biomes.field_76769_d);
    }

    public LayerMaterial getSandLayers(Biome biome) {
        return this.layerManager.getMaterial(Blocks.field_150354_m);
    }

    private static int distance2(MaterialColor mc1, MaterialColor mc2) {
        Color c1 = new Color(mc1.field_76291_p);
        Color c2 = new Color(mc2.field_76291_p);
        int dr = c1.getRed() - c2.getRed();
        int dg = c1.getGreen() - c2.getGreen();
        int db = c1.getBlue() - c2.getBlue();
        return dr * dr + dg * dg + db * db;
    }
}

