/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.biome.provider;

import com.google.common.collect.Sets;
import com.terraforged.core.cell.Cell;
import com.terraforged.core.concurrent.Resource;
import com.terraforged.mod.biome.map.BiomeMap;
import com.terraforged.mod.biome.modifier.BiomeModifierManager;
import com.terraforged.mod.biome.provider.BiomeHelper;
import com.terraforged.mod.chunk.TerraContext;
import com.terraforged.mod.util.setup.SetupHooks;
import com.terraforged.world.heightmap.WorldLookup;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.biome.ColumnFuzzedBiomeMagnifier;
import net.minecraft.world.biome.provider.BiomeProvider;

public class TerraBiomeProvider
extends BiomeProvider {
    private final long seed;
    private final BiomeMap biomeMap;
    private final TerraContext context;
    private final WorldLookup worldLookup;
    private final BiomeModifierManager modifierManager;

    public TerraBiomeProvider(TerraContext context) {
        super(BiomeHelper.getAllBiomes());
        this.context = context;
        this.seed = context.terraSettings.world.seed;
        this.biomeMap = BiomeHelper.createBiomeMap();
        this.worldLookup = new WorldLookup(context.factory, context);
        this.modifierManager = SetupHooks.setup(new BiomeModifierManager(context, this.biomeMap), context.copy());
    }

    public Resource<Cell> lookupPos(int x, int z) {
        return this.getWorldLookup().getCell(x, z);
    }

    public Biome getBiome(int x, int z) {
        try (Resource<Cell> resource = this.getWorldLookup().getCell(x, z, true);){
            Biome biome = this.getBiome(resource.get(), x, z);
            return biome;
        }
    }

    public Biome func_225526_b_(int x, int y, int z) {
        try (Resource<Cell> cell = this.lookupPos(x <<= 2, z <<= 2);){
            Biome biome = this.getBiome(cell.get(), x, z);
            return biome;
        }
    }

    public Set<Biome> func_225530_a_(int centerX, int centerY, int centerZ, int radius) {
        int minX = centerX - radius >> 2;
        int minZ = centerZ - radius >> 2;
        int maxX = centerX + radius >> 2;
        int maxZ = centerZ + radius >> 2;
        int rangeX = maxX - minX + 1;
        int rangeZ = maxZ - minZ + 1;
        HashSet set = Sets.newHashSet();
        Cell cell = new Cell();
        for (int dz = 0; dz < rangeZ; ++dz) {
            for (int dx = 0; dx < rangeX; ++dx) {
                int x = minX + dx << 2;
                int z = minZ + dz << 2;
                this.worldLookup.applyCell(cell, x, z);
                Biome biome = this.getBiome(cell, x, z);
                set.add(biome);
            }
        }
        return set;
    }

    public BlockPos func_225531_a_(int centerX, int centerY, int centerZ, int range, List<Biome> biomes, Random random) {
        int minX = centerX - range >> 2;
        int minZ = centerZ - range >> 2;
        int maxX = centerX + range >> 2;
        int maxZ = centerZ + range >> 2;
        int rangeX = maxX - minX + 1;
        int rangeZ = maxZ - minZ + 1;
        int y = centerY >> 2;
        BlockPos blockpos = null;
        int attempts = 0;
        Cell cell = new Cell();
        for (int dz = 0; dz < rangeZ; ++dz) {
            for (int dx = 0; dx < rangeX; ++dx) {
                int x = minX + dx << 2;
                int z = minZ + dz << 2;
                this.worldLookup.applyCell(cell, x, z);
                if (!biomes.contains(this.getBiome(cell, x, z))) continue;
                if (blockpos == null || random.nextInt(attempts + 1) == 0) {
                    blockpos = new BlockPos(x, y, z);
                }
                ++attempts;
            }
        }
        return blockpos;
    }

    public Biome getSurfaceBiome(int x, int z, BiomeManager.IBiomeReader reader) {
        return ColumnFuzzedBiomeMagnifier.INSTANCE.func_225532_a_(this.seed, x, 0, z, reader);
    }

    public WorldLookup getWorldLookup() {
        return this.worldLookup;
    }

    public TerraContext getContext() {
        return this.context;
    }

    public BiomeModifierManager getModifierManager() {
        return this.modifierManager;
    }

    public Biome getBiome(Cell cell, int x, int z) {
        Biome biome = this.biomeMap.provideBiome(cell, this.context.levels);
        if (this.modifierManager.hasModifiers(cell, this.context.levels)) {
            return this.modifierManager.modify(biome, cell, x, z);
        }
        return biome;
    }

    public boolean canSpawnAt(Cell cell) {
        return cell.terrain != this.context.terrain.ocean && cell.terrain != this.context.terrain.deepOcean;
    }
}

