/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.biome.surface;

import com.terraforged.api.biome.surface.Surface;
import com.terraforged.api.biome.surface.SurfaceContext;
import com.terraforged.api.material.state.States;
import com.terraforged.n2d.Module;
import com.terraforged.n2d.Source;
import com.terraforged.world.GeneratorContext;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;

public class SwampSurface
implements Surface {
    private final Module noise;
    private final SurfaceBuilderConfig config = SurfaceBuilder.field_215425_v;

    public SwampSurface(GeneratorContext context) {
        this.noise = Source.simplex(context.seed.next(), 40, 2).warp(Source.RAND, context.seed.next(), 2, 1, 4.0);
    }

    @Override
    public void buildSurface(int x, int z, int height, SurfaceContext ctx) {
        double noise = Biome.field_180281_af.func_215464_a((double)x * 0.25, (double)z * 0.25, false);
        if (noise > 0.0) {
            int dx = x & 0xF;
            int dz = z & 0xF;
            for (int y = height; y >= height - 10; --y) {
                ctx.pos.func_181079_c(dx, y, dz);
                if (ctx.buffer.func_180495_p((BlockPos)ctx.pos).func_196958_f()) continue;
                if (y != ctx.levels.waterY || ctx.buffer.func_180495_p((BlockPos)ctx.pos).func_177230_c() == ctx.fluid.func_177230_c()) break;
                ctx.buffer.func_177436_a((BlockPos)ctx.pos, ctx.fluid, false);
                break;
            }
        }
        SurfaceBuilder.field_215396_G.func_205610_a_((Random)ctx.random, (IChunk)ctx.buffer, ctx.biome, x, z, height, noise, ctx.solid, ctx.fluid, ctx.levels.waterLevel, ctx.seed, (ISurfaceBuilderConfig)this.config);
        int y = ctx.chunk.func_201576_a(Heightmap.Type.OCEAN_FLOOR_WG, x, z);
        if (y <= ctx.levels.waterY) {
            ctx.buffer.func_177436_a((BlockPos)ctx.pos.func_181079_c(x, y, z), this.getMaterial(x, y, z, ctx), false);
        }
    }

    private BlockState getMaterial(int x, int y, int z, SurfaceContext ctx) {
        float value = this.noise.getValue(x, z);
        if ((double)value > 0.6) {
            if ((double)value < 0.75 && y < ctx.levels.waterY) {
                return (BlockState)States.CLAY.get();
            }
            return (BlockState)States.GRAVEL.get();
        }
        return (BlockState)States.DIRT.get();
    }
}

