/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.chunk.fix;

import com.terraforged.api.chunk.ChunkDelegate;
import com.terraforged.api.material.state.States;
import com.terraforged.fm.template.StructureUtils;
import com.terraforged.mod.material.Materials;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;

public class ChunkCarverFix
implements ChunkDelegate {
    private final IChunk delegate;
    private final Materials materials;
    private final boolean hasSurfaceStructure;

    public ChunkCarverFix(IChunk chunk, Materials materials) {
        this.delegate = chunk;
        this.materials = materials;
        this.hasSurfaceStructure = StructureUtils.hasOvergroundStructure(chunk);
    }

    @Override
    public IChunk getDelegate() {
        return this.delegate;
    }

    @Override
    public BlockState func_180495_p(BlockPos pos) {
        BlockState state = this.getDelegate().func_180495_p(pos);
        if (this.materials.isAir(state.func_177230_c())) {
            return state;
        }
        if (this.materials.isGrass(state.func_177230_c())) {
            return (BlockState)States.GRASS_BLOCK.get();
        }
        if (this.materials.isStone(state.func_177230_c())) {
            return (BlockState)States.STONE.get();
        }
        if (this.materials.isEarth(state.func_177230_c())) {
            return (BlockState)States.DIRT.get();
        }
        if (this.materials.isClay(state.func_177230_c())) {
            return (BlockState)States.DIRT.get();
        }
        if (this.materials.isSediment(state.func_177230_c())) {
            return (BlockState)States.SAND.get();
        }
        return state;
    }

    @Override
    public BlockState func_177436_a(BlockPos pos, BlockState state, boolean isMoving) {
        if (this.hasSurfaceStructure) {
            int surface = this.delegate.func_201576_a(Heightmap.Type.WORLD_SURFACE, pos.func_177958_n(), pos.func_177952_p());
            if (pos.func_177956_o() > surface - 3) {
                return state;
            }
        }
        return this.delegate.func_177436_a(pos, state, isMoving);
    }
}

