/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.chunk.generator;

import com.terraforged.api.chunk.column.ColumnDecorator;
import com.terraforged.api.chunk.column.DecoratorContext;
import com.terraforged.core.tile.chunk.ChunkReader;
import com.terraforged.mod.chunk.TerraChunkGenerator;
import com.terraforged.mod.chunk.fix.RegionFix;
import com.terraforged.mod.chunk.generator.Generator;
import com.terraforged.mod.chunk.util.TerraContainer;
import com.terraforged.mod.util.Environment;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.WorldGenRegion;

public class FeatureGenerator
implements Generator.Features {
    private final TerraChunkGenerator generator;

    public FeatureGenerator(TerraChunkGenerator generator) {
        this.generator = generator;
    }

    @Override
    public final void generateFeatures(WorldGenRegion region) {
        int chunkX = region.func_201679_a();
        int chunkZ = region.func_201680_b();
        IChunk chunk = region.func_212866_a_(chunkX, chunkZ);
        ChunkReader reader = this.generator.getChunkReader(chunkX, chunkZ);
        TerraContainer container = TerraContainer.getOrCreate(chunk, reader, this.generator.getBiomeProvider());
        Biome biome = container.getFeatureBiome(reader);
        DecoratorContext context = this.generator.getContext().decorator(chunk);
        RegionFix regionFix = new RegionFix(region, this.generator);
        BlockPos pos = new BlockPos(context.blockX, 0, context.blockZ);
        this.generator.getFeatureManager().decorate(this.generator, (IWorld)regionFix, chunk, biome, pos);
        this.postProcess(reader, container, context);
        ((ChunkPrimer)chunk).func_225548_a_(container.bakeBiomes(Environment.isVanillaBiomes()));
        reader.close();
        reader.dispose();
    }

    private void postProcess(ChunkReader reader, TerraContainer container, DecoratorContext context) {
        List<ColumnDecorator> decorators = this.generator.getPostProcessors();
        reader.iterate(context, (cell, dx, dz, ctx) -> {
            int px = ctx.blockX + dx;
            int pz = ctx.blockZ + dz;
            int py = ctx.chunk.func_201576_a(Heightmap.Type.WORLD_SURFACE_WG, dx, dz);
            ctx.cell = cell;
            ctx.biome = container.getBiome(dx, dz);
            for (ColumnDecorator decorator : decorators) {
                decorator.decorate(ctx.chunk, (DecoratorContext)ctx, px, py, pz);
            }
        });
    }
}

