/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.chunk.generator;

import com.terraforged.mod.chunk.TerraChunkGenerator;
import com.terraforged.mod.chunk.generator.Generator;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.CatSpawner;
import net.minecraft.world.spawner.PatrolSpawner;
import net.minecraft.world.spawner.PhantomSpawner;
import net.minecraft.world.spawner.WorldEntitySpawner;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class MobGenerator
implements Generator.Mobs {
    private static volatile boolean mobSpawning = true;
    private final CatSpawner catSpawner = new CatSpawner();
    private final PatrolSpawner patrolSpawner = new PatrolSpawner();
    private final PhantomSpawner phantomSpawner = new PhantomSpawner();
    private final TerraChunkGenerator generator;

    public MobGenerator(TerraChunkGenerator generator) {
        this.generator = generator;
    }

    @Override
    public final void generateMobs(WorldGenRegion region) {
        if (mobSpawning) {
            int chunkX = region.func_201679_a();
            int chunkZ = region.func_201680_b();
            Biome biome = region.func_212866_a_(chunkX, chunkZ).func_225549_i_().func_225526_b_(0, 0, 0);
            SharedSeedRandom sharedseedrandom = new SharedSeedRandom();
            sharedseedrandom.func_202424_a(region.func_72905_C(), chunkX << 4, chunkZ << 4);
            WorldEntitySpawner.func_77191_a((IWorld)region, (Biome)biome, (int)chunkX, (int)chunkZ, (Random)sharedseedrandom);
        }
    }

    @Override
    public final void tickSpawners(ServerWorld world, boolean hostile, boolean peaceful) {
        this.phantomSpawner.func_203232_a(world, hostile, peaceful);
        this.patrolSpawner.func_222696_a(world, hostile, peaceful);
        this.catSpawner.func_221124_a(world, hostile, peaceful);
    }

    @Override
    public final List<Biome.SpawnListEntry> getSpawns(IWorld world, EntityClassification type, BlockPos pos) {
        if (Feature.field_202334_l.func_202383_b(world, pos)) {
            if (type == EntityClassification.MONSTER) {
                return Feature.field_202334_l.func_202279_e();
            }
            if (type == EntityClassification.CREATURE) {
                return Feature.field_202334_l.func_214469_f();
            }
        } else if (type == EntityClassification.MONSTER) {
            if (Feature.field_214536_b.func_175796_a(world, pos)) {
                return Feature.field_214536_b.func_202279_e();
            }
            if (Feature.field_202336_n.func_175796_a(world, pos)) {
                return Feature.field_202336_n.func_202279_e();
            }
        }
        return world.func_226691_t_(pos).func_76747_a(type);
    }

    @SubscribeEvent
    public static void tick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.side.isServer()) {
            mobSpawning = ((GameRules.BooleanValue)event.world.func_82736_K().func_223585_a(GameRules.field_223601_d)).func_223572_a();
        }
    }
}

