/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.chunk.generator;

import com.terraforged.api.chunk.column.DecoratorContext;
import com.terraforged.core.tile.chunk.ChunkReader;
import com.terraforged.mod.chunk.TerraChunkGenerator;
import com.terraforged.mod.chunk.column.BaseDecorator;
import com.terraforged.mod.chunk.generator.Generator;
import com.terraforged.mod.chunk.util.FastChunk;
import com.terraforged.mod.chunk.util.TerraContainer;
import com.terraforged.mod.feature.TerrainHelper;
import com.terraforged.world.climate.Climate;
import com.terraforged.world.heightmap.Levels;
import com.terraforged.world.terrain.Terrains;
import net.minecraft.world.IWorld;
import net.minecraft.world.chunk.IChunk;

public class TerrainGenerator
implements Generator.Terrain {
    private final Levels levels;
    private final Climate climate;
    private final Terrains terrain;
    private final TerraChunkGenerator generator;
    private final TerrainHelper terrainHelper;

    public TerrainGenerator(TerraChunkGenerator generator) {
        this.generator = generator;
        this.levels = generator.getContext().levels;
        this.terrain = generator.getContext().terrain;
        this.climate = generator.getContext().factory.getClimate();
        this.terrainHelper = new TerrainHelper(0.75f, 4.0f);
    }

    @Override
    public final void generateTerrain(IWorld world, IChunk chunk) {
        try (ChunkReader reader = this.generator.getChunkReader(chunk.func_76632_l().field_77276_a, chunk.func_76632_l().field_77275_b);){
            TerraContainer container = TerraContainer.getOrCreate(chunk, reader, this.generator.getBiomeProvider());
            try (DecoratorContext context = new DecoratorContext(FastChunk.wrap(chunk), this.levels, this.terrain, this.climate);){
                reader.iterate(context, (cell, dx, dz, ctx) -> {
                    int px = ctx.blockX + dx;
                    int pz = ctx.blockZ + dz;
                    int py = ctx.levels.scale(cell.value);
                    ctx.cell = cell;
                    ctx.biome = container.func_225526_b_(dx, world.func_181545_F(), dz);
                    BaseDecorator.INSTANCE.decorate(ctx.chunk, (DecoratorContext)ctx, px, py, pz);
                });
                this.terrainHelper.flatten(world, chunk);
            }
        }
    }
}

