/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.client.gui.element;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.CompoundNBT;

public interface Element {
    public static final AtomicInteger ID_COUNTER = new AtomicInteger(0);

    default public List<String> getTooltip() {
        return Collections.emptyList();
    }

    public static int nextID() {
        return ID_COUNTER.getAndAdd(1);
    }

    public static String getDisplayName(String name, CompoundNBT value) {
        String key = Element.getDisplayKey(name, value);
        if (key.endsWith(".")) {
            return "";
        }
        return I18n.func_135052_a((String)key, (Object[])new Object[0]);
    }

    public static List<String> getToolTip(String name, CompoundNBT value) {
        String key = Element.getCommentKey(name, value);
        if (key.endsWith(".")) {
            return Collections.emptyList();
        }
        return Collections.singletonList(I18n.func_135052_a((String)key, (Object[])new Object[0]));
    }

    public static String getDisplayKey(String name, CompoundNBT value) {
        return "display.terraforged." + Element.getKey(name, value);
    }

    public static String getCommentKey(String name, CompoundNBT value) {
        return "tooltip.terraforged." + Element.getKey(name, value);
    }

    public static String getKey(String name, CompoundNBT value) {
        return value.func_74775_l("#" + name).func_74779_i("key");
    }
}

