/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.client.gui.element;

import com.terraforged.mod.client.gui.element.Element;
import com.terraforged.mod.client.gui.element.TerraButton;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;

public class TerraToggle
extends TerraButton {
    private final boolean noname;
    private final String prefix;
    private final String name;
    private final CompoundNBT value;
    private final ListNBT options;
    private final List<String> tooltip;
    private int index;
    private Runnable callback = () -> {};

    public TerraToggle(String name, CompoundNBT value) {
        super(value.func_74779_i(name));
        this.name = name;
        this.value = value;
        this.prefix = Element.getDisplayName(name, value) + ": ";
        this.tooltip = Element.getToolTip(name, value);
        CompoundNBT meta = value.func_74775_l("#" + name);
        this.noname = meta.func_74764_b("noname");
        this.options = meta.func_150295_c("options", 8);
        for (int i = 0; i < this.options.size(); ++i) {
            String s = this.options.func_150307_f(i);
            if (!s.equals(value.func_74779_i(name))) continue;
            this.index = i;
            break;
        }
        if (this.noname) {
            this.setMessage(value.func_74779_i(name));
        } else {
            this.setMessage(this.prefix + value.func_74779_i(name));
        }
    }

    public TerraToggle callback(Runnable runnable) {
        this.callback = runnable;
        return this;
    }

    @Override
    public List<String> getTooltip() {
        return this.tooltip;
    }

    public boolean mouseClicked(double mx, double my, int button) {
        if (super.isValidClickButton(button)) {
            int direction = button == 0 ? 1 : -1;
            this.playDownSound(Minecraft.func_71410_x().func_147118_V());
            this.onClick(mx, my, direction);
            return true;
        }
        return false;
    }

    private void onClick(double mouseX, double mouseY, int direction) {
        super.onClick(mouseX, mouseY);
        this.index += direction;
        if (this.index >= this.options.size()) {
            this.index = 0;
        } else if (this.index < 0) {
            this.index = this.options.size() - 1;
        }
        String option = this.options.func_150307_f(this.index);
        this.value.func_74778_a(this.name, option);
        if (this.noname) {
            this.setMessage(option);
        } else {
            this.setMessage(this.prefix + option);
        }
        this.callback.run();
    }
}

