/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.client.gui.page;

import com.terraforged.mod.chunk.settings.SettingsHelper;
import com.terraforged.mod.chunk.settings.TerraSettings;
import com.terraforged.mod.chunk.settings.preset.Preset;
import com.terraforged.mod.chunk.settings.preset.PresetManager;
import com.terraforged.mod.client.gui.GuiKeys;
import com.terraforged.mod.client.gui.Instance;
import com.terraforged.mod.client.gui.OverlayScreen;
import com.terraforged.mod.client.gui.ScrollPane;
import com.terraforged.mod.client.gui.element.TerraButton;
import com.terraforged.mod.client.gui.element.TerraLabel;
import com.terraforged.mod.client.gui.element.TerraTextInput;
import com.terraforged.mod.client.gui.page.BasePage;
import com.terraforged.mod.client.gui.page.Page;
import com.terraforged.mod.client.gui.page.UpdatablePage;
import com.terraforged.mod.util.nbt.NBTHelper;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.nbt.CompoundNBT;

public class PresetsPage
extends BasePage {
    private static final Predicate<String> NAME_VALIDATOR = Pattern.compile("^[A-Za-z0-9\\-_ ]+$").asPredicate();
    private final Instance instance;
    private final UpdatablePage preview;
    private final Widget previewWidget;
    private final TerraTextInput nameInput;
    private final PresetManager manager = PresetManager.load();

    public PresetsPage(Instance instance, UpdatablePage preview, Widget widget) {
        CompoundNBT value = new CompoundNBT();
        value.func_74778_a("name", "");
        this.preview = preview;
        this.previewWidget = widget;
        this.instance = instance;
        this.nameInput = new TerraTextInput("name", value);
        this.nameInput.setColorValidator(NAME_VALIDATOR);
    }

    @Override
    public String getTitle() {
        return GuiKeys.PRESETS.get();
    }

    @Override
    public void close() {
        this.manager.saveAll();
    }

    @Override
    public void save() {
    }

    @Override
    protected void update() {
        this.preview.apply(settings -> NBTHelper.deserialize(this.instance.settingsData, settings));
    }

    @Override
    public void init(OverlayScreen parent) {
        this.rebuildPresetList();
        Page.Column right = this.getColumn(1);
        right.scrollPane.addButton((Widget)this.nameInput);
        right.scrollPane.addButton((Widget)new TerraButton(GuiKeys.PRESET_CREATE.get()){

            public void render(int x, int z, float ticks) {
                this.active = PresetsPage.this.nameInput.isValid();
                super.render(x, z, ticks);
            }

            public void onClick(double x, double y) {
                super.onClick(x, y);
                Preset preset = new Preset(PresetsPage.this.nameInput.getValue(), PresetsPage.this.instance.createCopy());
                PresetsPage.this.manager.add(preset);
                PresetsPage.this.nameInput.func_146180_a("");
                PresetsPage.this.setSelected(preset);
                PresetsPage.this.load(preset);
                PresetsPage.this.rebuildPresetList();
            }
        });
        right.scrollPane.addButton((Widget)new TerraButton(GuiKeys.PRESET_LOAD.get()){

            public void render(int x, int z, float ticks) {
                this.active = PresetsPage.this.hasSelectedPreset(false);
                super.render(x, z, ticks);
            }

            public void onClick(double x, double y) {
                super.onClick(x, y);
                PresetsPage.this.getSelected().ifPresent(preset -> PresetsPage.this.load(preset));
            }
        });
        right.scrollPane.addButton((Widget)new TerraButton(GuiKeys.PRESET_SAVE.get()){

            public void render(int x, int z, float ticks) {
                this.active = PresetsPage.this.hasSelectedPreset(true);
                super.render(x, z, ticks);
            }

            public void onClick(double x, double y) {
                super.onClick(x, y);
                PresetsPage.this.getSelected().ifPresent(preset -> {
                    if (preset.internal()) {
                        return;
                    }
                    TerraSettings settings = PresetsPage.this.instance.createCopy();
                    PresetsPage.this.manager.add(new Preset(preset.getName(), settings));
                    PresetsPage.this.manager.saveAll();
                    PresetsPage.this.rebuildPresetList();
                });
            }
        });
        right.scrollPane.addButton((Widget)new TerraButton(GuiKeys.PRESET_RESET.get()){

            public void render(int x, int z, float ticks) {
                this.active = PresetsPage.this.hasSelectedPreset(true);
                super.render(x, z, ticks);
            }

            public void onClick(double x, double y) {
                super.onClick(x, y);
                PresetsPage.this.getSelected().ifPresent(preset -> {
                    if (preset.internal()) {
                        return;
                    }
                    Preset reset = new Preset(preset.getName(), new TerraSettings());
                    PresetsPage.this.manager.add(reset);
                    PresetsPage.this.rebuildPresetList();
                });
            }
        });
        right.scrollPane.addButton((Widget)new TerraButton(GuiKeys.PRESET_DELETE.get()){

            public void render(int x, int z, float ticks) {
                this.active = PresetsPage.this.hasSelectedPreset(true);
                super.render(x, z, ticks);
            }

            public void onClick(double x, double y) {
                super.onClick(x, y);
                PresetsPage.this.getSelected().ifPresent(preset -> {
                    if (preset.internal()) {
                        return;
                    }
                    PresetsPage.this.manager.remove(preset.getName());
                    PresetsPage.this.rebuildPresetList();
                });
            }
        });
        right.scrollPane.addButton((Widget)new TerraButton(GuiKeys.PRESET_SET_DEFAULTS.get()){

            public void onClick(double x, double y) {
                super.onClick(x, y);
                Optional selected = PresetsPage.this.getSelected();
                if (selected.isPresent()) {
                    SettingsHelper.exportDefaults(((Preset)selected.get()).getSettings());
                } else {
                    SettingsHelper.exportDefaults(PresetsPage.this.instance.createCopy());
                }
            }
        });
        right.scrollPane.addButton((Widget)new TerraButton(GuiKeys.PRESET_CLEAR_DEFAULTS.get()){

            public void onClick(double x, double y) {
                super.onClick(x, y);
                TerraSettings settings = new TerraSettings();
                SettingsHelper.exportDefaults(settings);
            }
        });
        right.scrollPane.addButton(this.previewWidget);
        TerraButton spacer = PresetsPage.createSpacer();
        for (int i = 0; i < 10; ++i) {
            right.scrollPane.addButton((Widget)spacer);
        }
    }

    private boolean hasSelectedPreset(boolean checkEditable) {
        return this.getSelected().map(preset -> !checkEditable || !preset.internal()).orElse(false);
    }

    private void load(Preset preset) {
        this.instance.sync(preset.getSettings());
        this.update();
    }

    private void setSelected(Preset preset) {
        ScrollPane pane = this.getColumn((int)0).scrollPane;
        for (ScrollPane.Entry entry : pane.children()) {
            if (!entry.option.getMessage().equalsIgnoreCase(preset.getName())) continue;
            pane.setSelected((AbstractList.AbstractListEntry)entry);
            return;
        }
    }

    private Optional<Preset> getSelected() {
        ScrollPane.Entry entry = (ScrollPane.Entry)this.getColumn((int)0).scrollPane.getSelected();
        if (entry == null) {
            return Optional.empty();
        }
        return this.manager.get(entry.option.getMessage());
    }

    private void rebuildPresetList() {
        Page.Column left = this.getColumn(0);
        left.scrollPane.setSelected(null);
        left.scrollPane.setRenderSelection(true);
        left.scrollPane.children().clear();
        for (Preset preset : this.manager) {
            if (preset.internal()) {
                left.scrollPane.addButton((Widget)new TerraLabel(preset.getName(), preset.getDescription(), 0xAAAAAA));
                continue;
            }
            left.scrollPane.addButton((Widget)new TerraLabel(preset.getName()));
        }
    }

    private static TerraButton createSpacer() {
        return new TerraButton(""){

            public void render(int x, int y, float tick) {
            }
        };
    }
}

