/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.client.gui.preview;

import com.terraforged.core.cell.Cell;
import com.terraforged.n2d.util.NoiseUtil;
import com.terraforged.world.heightmap.Levels;
import java.awt.Color;

public enum RenderMode {
    BIOME_TYPE{

        @Override
        public boolean handlesWater() {
            return true;
        }

        @Override
        public int getColor(Cell cell, Levels levels, float scale, float bias) {
            switch (cell.terrain.getType()) {
                case DEEP_OCEAN: {
                    return RenderMode.rgba(0.63f, 0.65f, 0.8f);
                }
                case SHALLOW_OCEAN: {
                    return RenderMode.rgba(0.6f, 0.6f, 0.8f);
                }
                case BEACH: {
                    return RenderMode.rgba(0.2f, 0.4f, 0.75f);
                }
            }
            if (cell.value < levels.water) {
                return RenderMode.getWaterColor();
            }
            Color color = cell.biomeType.getColor();
            float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), new float[3]);
            return RenderMode.rgba(hsb[0], hsb[1], hsb[2] * scale + bias);
        }
    }
    ,
    TRANSITION_POINTS{

        @Override
        public boolean handlesWater() {
            return true;
        }

        @Override
        public int getColor(Cell cell, Levels levels, float scale, float bias) {
            switch (cell.terrain.getType()) {
                case DEEP_OCEAN: {
                    return RenderMode.rgba(0.63f, 0.65f, 0.8f);
                }
                case SHALLOW_OCEAN: {
                    return RenderMode.rgba(0.6f, 0.6f, 0.8f);
                }
                case BEACH: {
                    return RenderMode.rgba(0.2f, 0.4f, 0.75f);
                }
                case COAST: {
                    return RenderMode.rgba(0.35f, 0.75f, 0.65f);
                }
            }
            if (cell.terrain.isRiver() || cell.terrain.isWetland()) {
                return RenderMode.rgba(0.6f, 0.6f, 0.8f);
            }
            return RenderMode.rgba(0.3f, 0.7f, 0.5f);
        }
    }
    ,
    TEMPERATURE{

        @Override
        public int getColor(Cell cell, Levels levels, float scale, float bias) {
            float saturation = 0.7f;
            float brightness = 0.8f;
            return RenderMode.rgba(RenderMode.step(1.0f - cell.temperature, 8) * 0.65f, saturation, brightness);
        }
    }
    ,
    MOISTURE{

        @Override
        public int getColor(Cell cell, Levels levels, float scale, float bias) {
            float saturation = 0.7f;
            float brightness = 0.8f;
            return RenderMode.rgba(RenderMode.step(cell.moisture, 8) * 0.65f, saturation, brightness);
        }
    }
    ,
    BIOME{

        @Override
        public int getColor(Cell cell, Levels levels, float scale, float bias) {
            float saturation = 0.7f;
            float brightness = 0.8f;
            return RenderMode.rgba(cell.biomeIdentity, saturation, brightness);
        }
    }
    ,
    MACRO_NOISE{

        @Override
        public int getColor(Cell cell, Levels levels, float scale, float bias) {
            float saturation = 0.7f;
            float brightness = 0.8f;
            return RenderMode.rgba(cell.macroNoise, saturation, brightness);
        }
    }
    ,
    TERRAIN_REGION{

        @Override
        public int getColor(Cell cell, Levels levels, float scale, float bias) {
            float saturation = 0.7f;
            float brightness = 0.8f;
            return RenderMode.rgba(cell.terrain.getHue(), saturation, brightness);
        }
    };


    public int getColor(Cell cell, Levels levels) {
        if (!this.handlesWater() && cell.value < levels.water) {
            return RenderMode.getWaterColor();
        }
        float bands = 10.0f;
        float alpha = 0.2f;
        float elevation = (cell.value - levels.water) / (1.0f - levels.water);
        int band = NoiseUtil.round(elevation * bands);
        float scale = 1.0f - alpha;
        float bias = alpha * ((float)band / bands);
        return this.getColor(cell, levels, scale, bias);
    }

    public abstract int getColor(Cell var1, Levels var2, float var3, float var4);

    public boolean handlesWater() {
        return false;
    }

    private static int getWaterColor() {
        return RenderMode.rgba(40, 140, 200);
    }

    private static float step(float value, int steps) {
        return (float)NoiseUtil.round(value * (float)steps) / (float)steps;
    }

    private static int rgba(float h, float s, float b) {
        int argb = Color.HSBtoRGB(h, s, b);
        int red = argb >> 16 & 0xFF;
        int green = argb >> 8 & 0xFF;
        int blue = argb & 0xFF;
        return RenderMode.rgba(red, green, blue);
    }

    private static int rgba(int r, int g, int b) {
        return r + (g << 8) + (b << 16) + -16777216;
    }
}

