/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.toml.TomlFormat;
import com.terraforged.mod.Log;
import com.terraforged.mod.config.ConfigRef;
import com.terraforged.mod.config.PerfDefaults;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Consumer;
import joptsimple.internal.Strings;

public class ConfigManager {
    private static final Path COMMON_DIR = Paths.get("config", "terraforged").toAbsolutePath();
    public static final ConfigRef BIOME_WEIGHTS = new ConfigRef(() -> ConfigManager.create("biome_weights", cfg -> ConfigManager.set((CommentedConfig)cfg, "terraforged:example_biome", 10, "Configure biome weights by entering their id and an integer value for their weight (default weight is 10)", "This config will override the weights configured or provided by other mods for TerraForged worlds only.")));
    public static final ConfigRef PERFORMANCE = new ConfigRef(() -> ConfigManager.create("performance", cfg -> {
        ConfigManager.set((CommentedConfig)cfg, "thread_count", PerfDefaults.THREAD_COUNT, "Controls the total number of threads that will be used to generate heightmap tiles.", "Allowing the generator to use more threads can help speed up generation but increases overall", "load on your CPU which may adversely affect performance in other areas of the game engine.");
        ConfigManager.set((CommentedConfig)cfg, "tile_size", 3, "Controls the size of heightmap tiles.", "Smaller tiles are faster to generate but less memory efficient.");
        ConfigManager.set((CommentedConfig)cfg, "batching", false, "Batching breaks heightmap tiles up into smaller pieces that can be generated concurrently.", "This can help improve generation speed by utilizing more threads.", "It is more effective when a higher thread count (+6) is available.");
        ConfigManager.set((CommentedConfig)cfg, "batch_count", 6, "Controls the number of pieces a heightmap tile is divided up into.", "Higher batch counts may be able to utilize more of the available threads, improving performance.");
    }));
    public static final ConfigRef GENERAL = new ConfigRef(() -> ConfigManager.create("general", cfg -> {
        ConfigManager.set((CommentedConfig)cfg, "tooltips", true, "Set whether tooltips should be displayed by default in the config gui.");
        ConfigManager.set((CommentedConfig)cfg, "coords", false, "Set whether coordinates should be displayed by default in the config gui.");
    }));

    public static void init() {
        Config.setInsertionOrderPreserved((boolean)true);
        BIOME_WEIGHTS.get();
        PERFORMANCE.get();
        PerfDefaults.getAndPrintPerfSettings();
    }

    private static CommentedFileConfig create(String name, Consumer<CommentedFileConfig> defaulter) {
        Path path = COMMON_DIR.resolve(name + ".conf");
        if (!Files.exists(path, new LinkOption[0])) {
            Log.info("Creating default config: {}", name);
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            CommentedFileConfig config = CommentedFileConfig.of((Path)path, (ConfigFormat)TomlFormat.instance());
            defaulter.accept(config);
            config.save();
            return config;
        }
        return CommentedFileConfig.of((Path)path, (ConfigFormat)TomlFormat.instance());
    }

    private static <T> void set(CommentedConfig config, String path, T value, String ... lines) {
        config.setComment(path, Strings.join((String[])lines, (String)"\n"));
        config.set(path, value);
    }
}

