/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.data;

import com.google.gson.GsonBuilder;
import com.terraforged.mod.biome.map.BiomeMap;
import com.terraforged.mod.biome.provider.BiomeHelper;
import com.terraforged.mod.biome.provider.BiomeWeights;
import com.terraforged.mod.data.DataGen;
import com.terraforged.world.biome.BiomeType;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.minecraft.util.ResourceLocation;

public class WorldGenBiomes
extends DataGen {
    public static void genBiomeMap(File dataDir) {
        if (dataDir.exists() || dataDir.mkdirs()) {
            BiomeMap map = BiomeHelper.createBiomeMap();
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(new File(dataDir, "biome_map.json")));){
                new GsonBuilder().setPrettyPrinting().create().toJson(map.toJson(), (Appendable)writer);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void genBiomeWeights(File dataDir) {
        if (dataDir.exists() || dataDir.mkdirs()) {
            BiomeWeights weights = new BiomeWeights();
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(new File(dataDir, "biome_weights.txt")));){
                writer.write("# REGISTERED BIOME WEIGHTS\n");
                weights.forEachEntry((name, weight) -> {
                    try {
                        writer.write(name + "=" + weight + "\n");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                });
                writer.write("\n");
                writer.write("# UNREGISTERED BIOME WEIGHTS\n");
                weights.forEachUnregistered((name, weight) -> {
                    try {
                        writer.write(name + "=" + weight + "\n");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                });
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static ResourceLocation getName(BiomeType type) {
        return new ResourceLocation("terraforged", type.name().toLowerCase());
    }
}

