/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.terraforged.api.material.WGTags;
import com.terraforged.mod.data.DataGen;
import java.io.File;
import java.io.Writer;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;

public class WorldGenBlocks
extends DataGen {
    public static void genBlockTags(File dataDir) {
        if (dataDir.exists() || dataDir.mkdirs()) {
            WorldGenBlocks.printMaterials(dataDir, "forge:wg_stone", WGTags.STONE.func_199885_a());
            WorldGenBlocks.printMaterials(dataDir, "forge:wg_dirt", WGTags.DIRT.func_199885_a());
            WorldGenBlocks.printMaterials(dataDir, "forge:wg_clay", WGTags.CLAY.func_199885_a());
            WorldGenBlocks.printMaterials(dataDir, "forge:wg_sediment", WGTags.SEDIMENT.func_199885_a());
            WorldGenBlocks.printMaterials(dataDir, "forge:wg_erodible", WGTags.ERODIBLE.func_199885_a());
        }
    }

    private static void printMaterials(File dir, String name, Collection<Block> blocks) {
        String path = WorldGenBlocks.getJsonPath("tags/blocks", new ResourceLocation(name));
        WorldGenBlocks.write(new File(dir, path), (Writer writer) -> {
            JsonObject root = new JsonObject();
            JsonArray values = new JsonArray();
            root.addProperty("replace", Boolean.valueOf(false));
            root.add("values", (JsonElement)values);
            for (Block block : blocks) {
                values.add("" + block.getRegistryName());
            }
            WorldGenBlocks.write((JsonElement)root, writer);
        });
    }
}

