/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.terraforged.fm.FeatureSerializer;
import com.terraforged.fm.util.FeatureDebugger;
import com.terraforged.mod.Log;
import com.terraforged.mod.data.DataGen;
import java.io.File;
import java.io.Writer;
import java.util.List;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraftforge.registries.ForgeRegistries;

public class WorldGenFeatures
extends DataGen {
    public static void genBiomeFeatures(File dataDir) {
        if (dataDir.exists() || dataDir.mkdirs()) {
            for (Biome biome : ForgeRegistries.BIOMES) {
                WorldGenFeatures.genBiomeFeatures(dataDir, biome);
            }
        }
    }

    private static void genBiomeFeatures(File dir, Biome biome) {
        WorldGenFeatures.write(new File(dir, WorldGenFeatures.getJsonPath("features", biome.getRegistryName())), (Writer writer) -> {
            JsonObject root = new JsonObject();
            for (GenerationStage.Decoration type : GenerationStage.Decoration.values()) {
                JsonArray features = new JsonArray();
                for (ConfiguredFeature feature : biome.func_203607_a(type)) {
                    try {
                        JsonElement element = FeatureSerializer.serialize(feature);
                        features.add(element);
                    }
                    catch (Throwable t) {
                        String name = biome.getRegistryName() + "";
                        List<String> errors = FeatureDebugger.getErrors(feature);
                        Log.debug("Unable to serialize feature in biome: {}", name);
                        if (errors.isEmpty()) {
                            Log.debug("Unable to determine issues. See stacktrace:", t);
                            continue;
                        }
                        for (String error : errors) {
                            Log.debug(" - {}", error);
                        }
                    }
                }
                root.add(type.func_222676_a(), (JsonElement)features);
            }
            WorldGenFeatures.write((JsonElement)root, writer);
        });
    }
}

