/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.feature.context;

import com.terraforged.core.concurrent.Resource;
import com.terraforged.mod.feature.context.ChanceContext;
import com.terraforged.mod.feature.context.ContextSelectorConfig;
import com.terraforged.mod.feature.context.ContextualFeature;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;

public class ContextSelectorFeature
extends Feature<ContextSelectorConfig> {
    public static final ContextSelectorFeature INSTANCE = new ContextSelectorFeature();

    public ContextSelectorFeature() {
        super(ContextSelectorConfig::deserialize);
        this.setRegistryName("terraforged", "context_selector");
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random random, BlockPos pos, ContextSelectorConfig config) {
        try (Resource<ChanceContext> item = ChanceContext.pooled(world, generator);){
            if (item == null) {
                boolean bl = false;
                return bl;
            }
            ChanceContext context = item.get();
            context.setPos(pos);
            context.init(config.features.size());
            for (int i = 0; i < config.features.size(); ++i) {
                ContextualFeature feature = config.features.get(i);
                float chance = feature.getChance(pos, context);
                context.record(i, chance);
            }
            int index = context.nextIndex(random);
            if (index > -1) {
                boolean bl = config.features.get((int)index).feature.func_222734_a(world, generator, random, pos);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }
}

