/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.feature.decorator.poisson;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import com.terraforged.core.util.poisson.PoissonContext;
import com.terraforged.mod.feature.decorator.poisson.BiomeVariance;
import com.terraforged.n2d.Module;
import com.terraforged.n2d.Source;
import java.util.Map;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.placement.IPlacementConfig;

public class PoissonConfig
implements IPlacementConfig {
    public final int radius;
    public final float biomeFade;
    public final int densityNoiseScale;
    public final float densityNoiseMin;
    public final float densityNoiseMax;

    public PoissonConfig(int radius, float biomeFade, int densityNoiseScale, float densityNoiseMin, float densityNoiseMax) {
        this.radius = radius;
        this.biomeFade = biomeFade;
        this.densityNoiseScale = densityNoiseScale;
        this.densityNoiseMin = densityNoiseMin;
        this.densityNoiseMax = densityNoiseMax;
    }

    public void apply(IWorld world, ChunkGenerator<?> generator, PoissonContext context) {
        Module fade = Source.ONE;
        Module density = Source.ONE;
        if (this.biomeFade > 0.075f) {
            fade = BiomeVariance.of(world, generator, this.biomeFade);
        }
        if (this.densityNoiseScale > 0) {
            density = Source.simplex(context.seed, this.densityNoiseScale, 1).scale(this.densityNoiseMax - this.densityNoiseMin).bias(this.densityNoiseMin);
        }
        context.density = PoissonConfig.mult(fade, density);
    }

    public <T> Dynamic<T> func_214719_a(DynamicOps<T> ops) {
        return new Dynamic(ops, ops.createMap((Map)ImmutableMap.of((Object)ops.createString("radius"), (Object)ops.createInt(this.radius), (Object)ops.createString("biome_fade"), (Object)ops.createFloat(this.biomeFade), (Object)ops.createString("density_noise_scale"), (Object)ops.createInt(this.densityNoiseScale), (Object)ops.createString("density_noise_min"), (Object)ops.createFloat(this.densityNoiseMin), (Object)ops.createString("density_noise_max"), (Object)ops.createFloat(this.densityNoiseMax))));
    }

    public static PoissonConfig deserialize(Dynamic<?> dynamic) {
        int radius = dynamic.get("radius").asInt(4);
        float biomeFade = dynamic.get("biome_fade").asFloat(0.2f);
        int variance = dynamic.get("density_noise_scale").asInt(0);
        float min = dynamic.get("density_noise_min").asFloat(0.0f);
        float max = dynamic.get("density_noise_max").asFloat(1.0f);
        return new PoissonConfig(radius, biomeFade, variance, min, max);
    }

    private static Module mult(Module a, Module b) {
        if (a == Source.ONE) {
            return b;
        }
        if (b == Source.ONE) {
            return a;
        }
        return a.mult(b);
    }
}

