/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.server.command.search;

import com.terraforged.core.cell.Cell;
import com.terraforged.mod.biome.provider.TerraBiomeProvider;
import com.terraforged.mod.server.command.search.ChunkGeneratorSearch;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;

public class BiomeSearchTask
extends ChunkGeneratorSearch {
    private final Biome biome;
    private final TerraBiomeProvider biomeProvider;
    private final Cell cell = new Cell();

    public BiomeSearchTask(BlockPos center, Biome biome, ChunkGenerator<?> generator, TerraBiomeProvider biomeProvider) {
        super(center, generator);
        this.biomeProvider = biomeProvider;
        this.biome = biome;
    }

    @Override
    public int getSpacing() {
        return 10;
    }

    @Override
    public boolean test(BlockPos pos) {
        this.biomeProvider.getWorldLookup().applyCell(this.cell, pos.func_177958_n(), pos.func_177952_p());
        if (this.biomeProvider.getBiome(this.cell, pos.func_177958_n(), pos.func_177952_p()) == this.biome) {
            return this.biomeProvider.getBiome(pos.func_177958_n(), pos.func_177952_p()) == this.biome;
        }
        return false;
    }
}

