/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.util.setup;

import com.terraforged.api.biome.modifier.ModifierManager;
import com.terraforged.api.biome.surface.SurfaceManager;
import com.terraforged.api.chunk.column.ColumnDecorator;
import com.terraforged.api.chunk.column.DecoratorManager;
import com.terraforged.api.event.SetupEvent;
import com.terraforged.api.material.geology.GeologyManager;
import com.terraforged.api.material.layer.LayerManager;
import com.terraforged.fm.modifier.FeatureModifiers;
import com.terraforged.fm.structure.StructureManager;
import com.terraforged.world.GeneratorContext;
import com.terraforged.world.terrain.provider.TerrainProvider;
import java.util.List;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class SetupHooks {
    public static <T extends TerrainProvider> T setup(T provider, GeneratorContext context) {
        MinecraftForge.EVENT_BUS.post((Event)new SetupEvent.Terrain(provider, context));
        return provider;
    }

    public static <T extends SurfaceManager> T setup(T manager, GeneratorContext context) {
        MinecraftForge.EVENT_BUS.post((Event)new SetupEvent.Surface(manager, context));
        return manager;
    }

    public static <T extends ModifierManager> T setup(T manager, GeneratorContext context) {
        MinecraftForge.EVENT_BUS.post((Event)new SetupEvent.BiomeModifier(manager, context));
        return manager;
    }

    public static <T extends LayerManager> T setup(T manager, GeneratorContext context) {
        MinecraftForge.EVENT_BUS.post((Event)new SetupEvent.Layers(manager, context));
        return manager;
    }

    public static <T extends GeologyManager> T setup(T manager, GeneratorContext context) {
        MinecraftForge.EVENT_BUS.post((Event)new SetupEvent.Geology(manager, context));
        return manager;
    }

    public static <T extends FeatureModifiers> T setup(T manager, GeneratorContext context) {
        MinecraftForge.EVENT_BUS.post((Event)new SetupEvent.Features(manager, context));
        return manager;
    }

    public static <T extends StructureManager> T setup(T manager, GeneratorContext context) {
        MinecraftForge.EVENT_BUS.post((Event)new SetupEvent.Structures(manager, context));
        return manager;
    }

    public static void setup(List<ColumnDecorator> base, List<ColumnDecorator> feature, GeneratorContext context) {
        MinecraftForge.EVENT_BUS.post((Event)new SetupEvent.Decorators(new DecoratorManager(base, feature), context));
    }
}

