/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.n2d.domain;

import com.terraforged.cereal.spec.Context;
import com.terraforged.cereal.spec.DataSpec;
import com.terraforged.cereal.value.DataObject;
import com.terraforged.n2d.domain.Domain;

public class CumulativeWarp
implements Domain {
    private final Domain a;
    private final Domain b;

    public CumulativeWarp(Domain a, Domain b) {
        this.a = a;
        this.b = b;
    }

    @Override
    public String getSpecName() {
        return "CumulativeWarp";
    }

    @Override
    public float getOffsetX(float x, float y) {
        float ax = this.a.getX(x, y);
        float ay = this.a.getY(x, y);
        return this.b.getX(ax, ay);
    }

    @Override
    public float getOffsetY(float x, float y) {
        float ax = this.a.getX(x, y);
        float ay = this.a.getY(x, y);
        return this.b.getY(ax, ay);
    }

    private static CumulativeWarp create(DataObject data, DataSpec<?> spec, Context context) {
        return new CumulativeWarp(spec.get("warp_1", data, Domain.class, context), spec.get("warp_2", data, Domain.class, context));
    }

    public static DataSpec<? extends Domain> spec() {
        return DataSpec.builder("CumulativeWarp", CumulativeWarp.class, CumulativeWarp::create).addObj("warp_1", Domain.class, w -> w.a).addObj("warp_2", Domain.class, w -> w.b).build();
    }
}

