/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.n2d.modifier;

import com.terraforged.cereal.spec.DataFactory;
import com.terraforged.cereal.spec.DataSpec;
import com.terraforged.n2d.Module;
import com.terraforged.n2d.func.CurveFunc;
import com.terraforged.n2d.modifier.Modifier;
import com.terraforged.n2d.util.NoiseUtil;

public class Steps
extends Modifier {
    private final Module steps;
    private final Module slopeMin;
    private final Module slopeMax;
    private final CurveFunc curve;
    private static final DataFactory<Steps> factory = (data, spec, context) -> new Steps(spec.get("source", data, Module.class, context), spec.get("steps", data, Module.class, context), spec.get("slope_min", data, Module.class, context), spec.get("slope_max", data, Module.class, context), spec.get("curve", data, CurveFunc.class, context));

    public Steps(Module source, Module steps, Module slopeMin, Module slopeMax, CurveFunc slopeCurve) {
        super(source);
        this.steps = steps;
        this.curve = slopeCurve;
        this.slopeMin = slopeMin;
        this.slopeMax = slopeMax;
    }

    @Override
    public String getSpecName() {
        return "Steps";
    }

    @Override
    public float modify(float x, float y, float noiseValue) {
        float min = this.slopeMin.getValue(x, y);
        float max = this.slopeMax.getValue(x, y);
        float stepCount = this.steps.getValue(x, y);
        float range = max - min;
        if (range <= 0.0f) {
            return (float)((int)(noiseValue * stepCount)) / stepCount;
        }
        noiseValue = 1.0f - noiseValue;
        float value = (float)((int)(noiseValue * stepCount)) / stepCount;
        float delta = noiseValue - value;
        float alpha = NoiseUtil.map(delta * stepCount, min, max, range);
        return 1.0f - NoiseUtil.lerp(value, noiseValue, this.curve.apply(alpha));
    }

    public static DataSpec<Steps> spec() {
        return Steps.specBuilder(Steps.class, factory).addObj("curve", CurveFunc.class, s -> s.curve).addObj("source", Module.class, s -> s.source).addObj("steps", Module.class, s -> s.steps).addObj("slope_min", Module.class, s -> s.slopeMin).addObj("slope_max", Module.class, s -> s.slopeMax).build();
    }
}

