/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.n2d.source;

import com.terraforged.cereal.spec.DataFactory;
import com.terraforged.cereal.spec.DataSpec;
import com.terraforged.cereal.value.DataValue;
import com.terraforged.n2d.Module;
import com.terraforged.n2d.source.Builder;
import com.terraforged.n2d.source.FastSource;
import com.terraforged.n2d.util.NoiseUtil;

public class FastSin
extends FastSource {
    private final Module alpha;
    private static final DataFactory<FastSin> factory = (data, spec, context) -> new FastSin(new Builder().frequency(spec.get("frequency", data, DataValue::asDouble)).source(spec.get("alpha", data, Module.class, context)));

    public FastSin(Builder builder) {
        super(builder);
        this.alpha = builder.getSource();
    }

    @Override
    public String getSpecName() {
        return "Sin";
    }

    @Override
    public float getValue(float x, float y, int seed) {
        float noise;
        float a = this.alpha.getValue(x, y);
        x *= this.frequency;
        y *= this.frequency;
        if (a == 0.0f) {
            noise = NoiseUtil.sin(x);
        } else if (a == 1.0f) {
            noise = NoiseUtil.sin(y);
        } else {
            float sx = NoiseUtil.sin(x);
            float sy = NoiseUtil.sin(y);
            noise = NoiseUtil.lerp(sx, sy, a);
        }
        return NoiseUtil.map(noise, -1.0f, 1.0f, 2.0f);
    }

    public static DataSpec<FastSin> spec() {
        return DataSpec.builder("Sin", FastSin.class, factory).add("frequency", Float.valueOf(1.0f), s -> Float.valueOf(s.frequency)).addObj("alpha", s -> s.alpha).build();
    }
}

