/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.n2d.source;

import com.terraforged.cereal.spec.DataFactory;
import com.terraforged.cereal.spec.DataSpec;
import com.terraforged.n2d.Module;
import com.terraforged.n2d.source.Builder;
import com.terraforged.n2d.source.FastSource;
import com.terraforged.n2d.util.Noise;
import com.terraforged.n2d.util.NoiseUtil;

public class Rand
implements Module {
    private final int seed;
    private final float frequency;
    private static final DataFactory<Rand> factory = (data, spec, context) -> new Rand(FastSource.readData(data, spec, context));

    public Rand(Builder builder) {
        this.seed = builder.getSeed();
        this.frequency = builder.getFrequency();
    }

    @Override
    public String getSpecName() {
        return "Rand";
    }

    @Override
    public float getValue(float x, float y) {
        float value = Noise.white(x *= this.frequency, y *= this.frequency, this.seed);
        return Math.abs(value);
    }

    public float getValue(float x, float y, int childSeed) {
        return Noise.white(x, y, NoiseUtil.hash(this.seed, childSeed));
    }

    public int nextInt(float x, float y, int range) {
        float noise = this.getValue(x, y);
        return NoiseUtil.round((float)range * noise / (float)(range + range));
    }

    public int nextInt(float x, float y, int childSeed, int range) {
        float noise = this.getValue(x, y, childSeed);
        return NoiseUtil.round((float)range * noise / (float)(range + range));
    }

    public static DataSpec<Rand> spec() {
        return DataSpec.builder("Rand", Rand.class, factory).add("seed", 0, r -> r.seed).add("frequency", Float.valueOf(1.0f), r -> Float.valueOf(r.frequency)).build();
    }
}

