/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.world.rivermap.gen;

import com.terraforged.core.Seed;
import com.terraforged.core.util.Variance;
import com.terraforged.n2d.util.NoiseUtil;
import com.terraforged.n2d.util.Vec2f;
import com.terraforged.world.GeneratorContext;
import com.terraforged.world.continent.MutableVeci;
import com.terraforged.world.heightmap.Heightmap;
import com.terraforged.world.heightmap.Levels;
import com.terraforged.world.rivermap.Rivermap;
import com.terraforged.world.rivermap.gen.GenRiver;
import com.terraforged.world.rivermap.gen.GenWarp;
import com.terraforged.world.rivermap.lake.Lake;
import com.terraforged.world.rivermap.lake.LakeConfig;
import com.terraforged.world.rivermap.river.River;
import com.terraforged.world.rivermap.river.RiverBounds;
import com.terraforged.world.rivermap.river.RiverConfig;
import com.terraforged.world.rivermap.wetland.Wetland;
import com.terraforged.world.rivermap.wetland.WetlandConfig;
import com.terraforged.world.terrain.Terrains;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;

public class RiverGenerator {
    private static final Variance MAIN_VALLEY = Variance.of(0.8, 0.7);
    private static final Variance FORK_VALLEY = Variance.of(0.4, 0.75);
    private static final Variance FORK_ANGLE = Variance.of(0.05, 0.075);
    private static final Variance MAIN_SPACING = Variance.of(0.05, 0.2);
    private static final float CONTINENT_MODIFIER_MIN = 0.025f;
    private static final float CONTINENT_MODIFIER_RANGE = 0.1f;
    private static final AtomicInteger listSize = new AtomicInteger(32);
    private final int count;
    private final Seed seed;
    private final LakeConfig lake;
    private final RiverConfig main;
    private final RiverConfig fork;
    private final WetlandConfig wetland;
    private final Terrains terrain;
    private final Heightmap heightmap;
    private final Levels levels;

    public RiverGenerator(Heightmap heightmap, GeneratorContext context) {
        this.heightmap = heightmap;
        this.levels = context.levels;
        this.seed = context.seed.nextSeed();
        this.count = context.settings.rivers.riverCount;
        this.main = RiverConfig.builder(context.levels).bankHeight(context.settings.rivers.mainRivers.minBankHeight, context.settings.rivers.mainRivers.maxBankHeight).bankWidth(context.settings.rivers.mainRivers.bankWidth).bedWidth(context.settings.rivers.mainRivers.bedWidth).bedDepth(context.settings.rivers.mainRivers.bedDepth).fade(context.settings.rivers.mainRivers.fade).length(5000).main(true).order(0).build();
        this.fork = RiverConfig.builder(context.levels).bankHeight(context.settings.rivers.branchRivers.minBankHeight, context.settings.rivers.branchRivers.maxBankHeight).bankWidth(context.settings.rivers.branchRivers.bankWidth).bedWidth(context.settings.rivers.branchRivers.bedWidth).bedDepth(context.settings.rivers.branchRivers.bedDepth).fade(context.settings.rivers.branchRivers.fade).length(4500).order(1).build();
        this.wetland = new WetlandConfig(context.settings.rivers.wetlands);
        this.lake = LakeConfig.of(context.settings.rivers.lakes, context.levels);
        this.terrain = context.terrain;
    }

    public Rivermap compute(int x, int z, long id) {
        Random random = new Random(id);
        GenWarp warp = new GenWarp((int)id);
        int size = listSize.get();
        ArrayList<Lake> lakes = new ArrayList<Lake>(size);
        ArrayList<River> rivers = new ArrayList<River>(size);
        ArrayList<Wetland> wetland = new ArrayList<Wetland>(size);
        List<GenRiver> rootRivers = this.generateRoots(x, z, random, warp, rivers, lakes);
        Collections.shuffle(rootRivers, random);
        for (GenRiver root : rootRivers) {
            this.generateForks(root.river, root.angle, MAIN_SPACING, this.fork, random, warp, rivers, lakes);
        }
        this.generateAdditionalLakes(x, z, random, warp, rootRivers, rivers, lakes);
        rivers.sort(Collections.reverseOrder());
        this.generateWetlands(random, rivers, wetland);
        if (rivers.size() > size) {
            listSize.set(rivers.size());
        }
        return new Rivermap(x, z, warp, rivers, lakes, wetland);
    }

    private List<GenRiver> generateRoots(int x, int z, Random random, GenWarp warp, List<River> rivers, List<Lake> lakes) {
        MutableVeci pos = new MutableVeci(x, z);
        float start = random.nextFloat();
        float spacing = (float)Math.PI * 2 / (float)this.count;
        float spaceVar = spacing * 0.75f;
        float spaceBias = -spaceVar / 2.0f;
        ArrayList<GenRiver> roots = new ArrayList<GenRiver>(this.count);
        for (int i = 0; i < this.count; ++i) {
            float variance = random.nextFloat() * spaceVar + spaceBias;
            float angle = start + spacing * (float)i + variance;
            float dx = NoiseUtil.sin(angle);
            float dz = NoiseUtil.cos(angle);
            float startMod = 0.05f + random.nextFloat() * 0.35f;
            float length = this.heightmap.getContinent().getDistanceToOcean(x, z, dx, dz, pos);
            float startDist = Math.max(300.0f, startMod * length);
            float x1 = (float)x + dx * startDist;
            float z1 = (float)z + dz * startDist;
            float x2 = (float)x + dx * (length + 250.0f);
            float z2 = (float)z + dz * (length + 250.0f);
            float valleyWidth = 275.0f * MAIN_VALLEY.next(random);
            RiverBounds bounds = new RiverBounds((int)x1, (int)z1, (int)x2, (int)z2);
            River.Settings settings = RiverGenerator.creatSettings(random);
            settings.fadeIn = this.main.fade;
            settings.valleySize = valleyWidth;
            River river = new River(bounds, this.main, settings, this.terrain, this.levels);
            roots.add(new GenRiver(river, angle, dx, dz, length));
            rivers.add(river);
            this.addLake(river, random, warp, lakes);
        }
        return roots;
    }

    private void generateForks(River parent, float parentAngle, Variance spacing, RiverConfig config, Random random, GenWarp warp, List<River> rivers, List<Lake> lakes) {
        int direction = random.nextBoolean() ? 1 : -1;
        for (float offset = 0.3f; offset < 0.8f; offset += spacing.next(random)) {
            boolean attempt = true;
            while (attempt) {
                direction = -direction;
                float change = (float)direction * ((float)Math.PI * 2) * FORK_ANGLE.next(random);
                float angle = parentAngle + change;
                float dx = NoiseUtil.sin(angle);
                float dz = NoiseUtil.cos(angle);
                float length = (float)config.length * offset * 0.5f;
                Vec2f v1 = parent.bounds.pos(offset);
                float x2 = v1.x - dx * length;
                float z2 = v1.y - dz * length;
                float forkWidth = (float)parent.config.bankWidth * offset * 0.75f;
                float valleyWidth = 275.0f * FORK_VALLEY.next(random);
                RiverConfig forkConfig = config.createFork(forkWidth);
                RiverBounds bounds = new RiverBounds((int)x2, (int)z2, (int)v1.x, (int)v1.y);
                River.Settings settings = RiverGenerator.creatSettings(random);
                settings.connecting = true;
                settings.fadeIn = config.fade;
                settings.valleySize = valleyWidth;
                River fork = new River(bounds, forkConfig, settings, this.terrain, this.levels);
                if (!this.riverOverlaps(fork, parent, rivers)) {
                    rivers.add(fork);
                }
                attempt = false;
            }
        }
        this.addLake(parent, random, warp, lakes);
    }

    private void generateAdditionalLakes(int x, int z, Random random, GenWarp warp, List<GenRiver> roots, List<River> rivers, List<Lake> lakes) {
        Collections.sort(roots);
        float size = 150.0f;
        Variance sizeVariance = Variance.of(1.0, 0.25);
        Variance angleVariance = Variance.of(1.99f, 0.02f);
        Variance distanceVariance = Variance.of(0.6f, 0.3f);
        int i = 0;
        while (i + 1 < roots.size()) {
            GenRiver a = roots.get(i);
            GenRiver b = roots.get(i + 1);
            float angle = (a.angle + b.angle) / angleVariance.next(random);
            float dx = NoiseUtil.sin(angle);
            float dz = NoiseUtil.cos(angle);
            float distance = distanceVariance.next(random);
            float lx = (float)x + dx * a.length * distance;
            float lz = (float)z + dz * a.length * distance;
            float variance = sizeVariance.next(random);
            Vec2f center = new Vec2f(lx, lz);
            if (!this.lakeOverlaps(center, size, rivers)) {
                lakes.add(new Lake(center, size, variance, this.lake, this.terrain));
            }
            ++i;
        }
    }

    private void generateWetlands(Random random, List<River> rivers, List<Wetland> wetlands) {
        Iterator<River> iterator = rivers.iterator();
        while (iterator.hasNext()) {
            River river = iterator.next();
            int skip = random.nextInt(this.wetland.skipSize);
            while (--skip > 0 && iterator.hasNext()) {
                river = iterator.next();
            }
            if (river == null) break;
            float width = this.wetland.width.next(random);
            float length = this.wetland.length.next(random);
            float riverLength = river.bounds.length();
            float startPos = random.nextFloat() * 0.75f;
            float endPos = startPos + random.nextFloat() * (length / riverLength);
            Vec2f start = river.bounds.pos(startPos);
            Vec2f end = river.bounds.pos(endPos);
            wetlands.add(new Wetland(this.seed, start, end, width, this.levels, this.terrain));
        }
    }

    private void addLake(River river, Random random, GenWarp warp, List<Lake> lakes) {
        if (random.nextFloat() <= this.lake.chance) {
            float lakeSize = this.lake.sizeMin + random.nextFloat() * this.lake.sizeRange;
            Vec2f center = river.bounds.pos(0.04f);
            if (this.lakeOverlapsOther(center, lakeSize, lakes)) {
                return;
            }
            float x1 = warp.river.getX(center.x, center.y);
            float z1 = warp.river.getY(center.x, center.y);
            lakes.add(new Lake(new Vec2f(x1, z1), lakeSize, 1.0f, this.lake, this.terrain));
        }
    }

    private boolean riverOverlaps(River river, River parent, List<River> rivers) {
        for (River other : rivers) {
            if (other == parent || !other.bounds.overlaps(river.bounds) || !other.bounds.intersects(river.bounds)) continue;
            return true;
        }
        return false;
    }

    private boolean lakeOverlaps(Vec2f lake, float size, List<River> rivers) {
        for (River other : rivers) {
            if (other.main || !other.bounds.overlaps(lake, size)) continue;
            return true;
        }
        return false;
    }

    private boolean lakeOverlapsOther(Vec2f lake, float size, List<Lake> lakes) {
        float dist2 = size * size;
        for (Lake other : lakes) {
            if (!other.overlaps(lake.x, lake.y, dist2)) continue;
            return true;
        }
        return false;
    }

    private static River.Settings creatSettings(Random random) {
        River.Settings settings = new River.Settings();
        settings.valleyCurve = River.getValleyType(random);
        settings.continentRiverModifier = 0.025f * random.nextFloat();
        settings.continentValleyModifier = settings.continentRiverModifier + 0.1f * random.nextFloat();
        return settings;
    }
}

