/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.world.rivermap.wetland;

import com.terraforged.core.Seed;
import com.terraforged.core.cell.Cell;
import com.terraforged.n2d.Module;
import com.terraforged.n2d.Source;
import com.terraforged.n2d.source.Line;
import com.terraforged.n2d.util.NoiseUtil;
import com.terraforged.n2d.util.Vec2f;
import com.terraforged.world.heightmap.Levels;
import com.terraforged.world.terrain.Terrains;
import com.terraforged.world.terrain.populator.TerrainPopulator;

public class Wetland
extends TerrainPopulator {
    public static final float WIDTH_MIN = 50.0f;
    public static final float WIDTH_MAX = 150.0f;
    private static final float VALLEY = 0.6f;
    private static final float POOLS = 0.7f;
    private static final float BANKS = 0.099999964f;
    private final Line line;
    private final float bed;
    private final float banks;
    private final float moundMin;
    private final float moundMax;
    private final float moundVariance;
    private final Module moundShape;
    private final Module moundHeight;
    private final Module terrainEdge;

    public Wetland(Seed seed, Vec2f a, Vec2f b, float radius, Levels levels, Terrains terrains) {
        super(terrains.wetlands, Source.ZERO, Source.ZERO);
        this.bed = levels.water(-1) - 0.5f / (float)levels.worldHeight;
        this.banks = levels.ground(4);
        this.moundMin = levels.water(1);
        this.moundMax = levels.water(2);
        this.moundVariance = this.moundMax - this.moundMin;
        this.line = Source.line((double)a.x, (double)a.y, (double)b.x, (double)b.y, radius, 0.0, 0.0);
        this.moundShape = Source.perlin(seed.next(), 10, 1).clamp(0.3, 0.6).map(0.0, 1.0);
        this.moundHeight = Source.simplex(seed.next(), 20, 1).clamp(0.0, 0.3).map(0.0, 1.0);
        this.terrainEdge = Source.perlin(seed.next(), 8, 1).clamp(0.2, 0.8).map(0.0, 0.9);
    }

    @Override
    public void apply(Cell cell, float x, float z) {
    }

    public void apply(Cell cell, float rx, float rz, float x, float z) {
        if (cell.value < this.bed) {
            return;
        }
        float dist = this.line.getValue(rx, rz);
        if (dist <= 0.0f) {
            return;
        }
        float valleyAlpha = NoiseUtil.map(dist, 0.0f, 0.6f, 0.6f);
        if (cell.value > this.banks) {
            cell.value = NoiseUtil.lerp(cell.value, this.banks, valleyAlpha);
        }
        float poolsAlpha = NoiseUtil.map(dist, 0.6f, 0.7f, 0.099999964f);
        if (cell.value > this.bed && cell.value <= this.banks) {
            cell.value = NoiseUtil.lerp(cell.value, this.bed, poolsAlpha);
        }
        if (poolsAlpha >= 1.0f) {
            cell.erosionMask = true;
        }
        if (dist > 0.6f && poolsAlpha > this.terrainEdge.getValue(x, z)) {
            cell.terrain = this.getType();
        }
        if (cell.value >= this.bed && cell.value < this.moundMax) {
            float shapeAlpha = this.moundShape.getValue(x, z) * poolsAlpha;
            float mounds = this.moundMin + this.moundHeight.getValue(x, z) * this.moundVariance;
            cell.value = NoiseUtil.lerp(cell.value, mounds, shapeAlpha);
        }
        cell.riverMask *= 1.0f - valleyAlpha;
    }
}

