/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.world.terrain;

import com.terraforged.world.terrain.Terrain;

public class MixedTerarin
extends Terrain {
    private final boolean flat;
    private final float erosion;

    public MixedTerarin(Terrain a, Terrain b) {
        super(a.getName() + "-" + b.getName(), Math.min(a.getWeight(), b.getWeight()), a.getType().getDominant(b.getType()));
        this.flat = a.isFlat() && b.isFlat();
        this.erosion = Math.min(a.erosionModifier(), b.erosionModifier());
    }

    @Override
    public float erosionModifier() {
        return this.erosion;
    }

    @Override
    public boolean isFlat() {
        return this.flat;
    }
}

