/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.world.terrain.populator;

import com.terraforged.core.cell.Cell;
import com.terraforged.core.cell.Populator;
import com.terraforged.core.settings.TerrainSettings;
import com.terraforged.n2d.Module;
import com.terraforged.n2d.Source;
import com.terraforged.world.terrain.Terrain;
import com.terraforged.world.terrain.populator.HScalePopulator;
import com.terraforged.world.terrain.populator.HVScalePopulator;
import com.terraforged.world.terrain.populator.VScalePopulator;

public class TerrainPopulator
implements Populator {
    protected final Terrain type;
    protected final Module base;
    protected final Module variance;

    public TerrainPopulator(Terrain type, Module base, Module variance) {
        this.type = type;
        this.base = base;
        this.variance = variance;
    }

    public Module getVariance() {
        return this.variance;
    }

    public Terrain getType() {
        return this.type;
    }

    @Override
    public void apply(Cell cell, float x, float z) {
        float base = this.base.getValue(x, z);
        float variance = this.variance.getValue(x, z);
        cell.value = base + variance;
        if (cell.value < 0.0f) {
            cell.value = 0.0f;
        } else if (cell.value > 1.0f) {
            cell.value = 1.0f;
        }
        cell.terrain = this.type;
    }

    public static Module clamp(Module module) {
        if (module.minValue() < 0.0f || module.maxValue() > 1.0f) {
            return module.clamp(0.0, 1.0);
        }
        return module;
    }

    public static TerrainPopulator of(Terrain type, Module variance) {
        return new TerrainPopulator(type, Source.ZERO, variance);
    }

    public static TerrainPopulator of(Terrain type, Module base, Module variance, TerrainSettings.Terrain settings) {
        if (settings.horizontalScale == 1.0f) {
            if (settings.verticalScale == 1.0f && settings.baseScale == 1.0f) {
                return new TerrainPopulator(type, base, variance);
            }
            return new VScalePopulator(type, base, variance, settings.baseScale, settings.verticalScale);
        }
        if (settings.verticalScale == 1.0f && settings.baseScale == 1.0f) {
            return new HScalePopulator(type, base, variance, settings.horizontalScale);
        }
        return new HVScalePopulator(type, base, variance, settings.baseScale, settings.verticalScale, settings.horizontalScale);
    }
}

