/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.world.terrain.provider;

import com.terraforged.core.Seed;
import com.terraforged.core.cell.Populator;
import com.terraforged.core.settings.TerrainSettings;
import com.terraforged.n2d.Module;
import com.terraforged.n2d.Source;
import com.terraforged.world.GeneratorContext;
import com.terraforged.world.heightmap.RegionConfig;
import com.terraforged.world.terrain.LandForms;
import com.terraforged.world.terrain.MixedTerarin;
import com.terraforged.world.terrain.Terrain;
import com.terraforged.world.terrain.populator.TerrainPopulator;
import com.terraforged.world.terrain.provider.TerrainProvider;
import com.terraforged.world.terrain.special.VolcanoPopulator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;

public class StandardTerrainProvider
implements TerrainProvider {
    private final List<TerrainPopulator> mixable = new ArrayList<TerrainPopulator>();
    private final List<TerrainPopulator> unmixable = new ArrayList<TerrainPopulator>();
    private final Map<Terrain, List<Populator>> populators = new HashMap<Terrain, List<Populator>>();
    private final LandForms landForms;
    private final RegionConfig config;
    private final TerrainSettings settings;
    private final GeneratorContext context;
    private final Populator defaultPopulator;

    public StandardTerrainProvider(GeneratorContext context, RegionConfig config, Populator defaultPopulator) {
        this.config = config;
        this.context = context;
        this.settings = context.settings.terrain;
        this.landForms = new LandForms(context.settings.terrain, context.levels);
        this.defaultPopulator = defaultPopulator;
        this.init();
    }

    public void init() {
        this.registerMixable(this.context.terrain.dales, this.landForms.getLandBase(), this.landForms.dales(this.context.seed), this.settings.dales);
        this.registerMixable(this.context.terrain.hills, this.landForms.getLandBase(), this.landForms.hills1(this.context.seed), this.settings.hills);
        this.registerMixable(this.context.terrain.hills, this.landForms.getLandBase(), this.landForms.hills2(this.context.seed), this.settings.hills);
        this.registerMixable(this.context.terrain.steppe, this.landForms.getLandBase(), this.landForms.steppe(this.context.seed), this.settings.steppe);
        this.registerMixable(this.context.terrain.plains, this.landForms.getLandBase(), this.landForms.plains(this.context.seed), this.settings.plains);
        this.registerMixable(this.context.terrain.plateau, this.landForms.getLandBase(), this.landForms.plateau(this.context.seed), this.settings.plateau);
        this.registerMixable(this.context.terrain.badlands, this.landForms.getLandBase(), this.landForms.badlands(this.context.seed), this.settings.badlands);
        this.registerMixable(this.context.terrain.torridonian, this.landForms.getLandBase(), this.landForms.torridonian(this.context.seed), this.settings.torridonian);
        this.registerUnMixable(this.context.terrain.badlands, this.landForms.getLandBase(), this.landForms.badlands(this.context.seed), this.settings.badlands);
        this.registerUnMixable(this.context.terrain.mountains, this.landForms.getLandBase(), this.landForms.mountains(this.context.seed), this.settings.mountains);
        this.registerUnMixable(this.context.terrain.mountains, this.landForms.getLandBase(), this.landForms.mountains2(this.context.seed), this.settings.mountains);
        this.registerUnMixable(this.context.terrain.mountains, this.landForms.getLandBase(), this.landForms.mountains3(this.context.seed), this.settings.mountains);
        this.registerUnMixable(new VolcanoPopulator(this.context.seed, this.config, this.context.levels, this.context.terrain));
    }

    @Override
    public void registerMixable(TerrainPopulator populator) {
        this.populators.computeIfAbsent(populator.getType(), t -> new ArrayList()).add(populator);
        this.mixable.add(populator);
    }

    @Override
    public void registerUnMixable(TerrainPopulator populator) {
        this.populators.computeIfAbsent(populator.getType(), t -> new ArrayList()).add(populator);
        this.unmixable.add(populator);
    }

    @Override
    public int getVariantCount(Terrain terrain) {
        List<Populator> list = this.populators.get(terrain);
        if (list == null) {
            return 0;
        }
        return list.size();
    }

    @Override
    public Populator getPopulator(Terrain terrain, int variant) {
        if (variant < 0) {
            return this.defaultPopulator;
        }
        List<Populator> list = this.populators.get(terrain);
        if (list == null) {
            return this.defaultPopulator;
        }
        if (variant >= list.size()) {
            variant = list.size() - 1;
        }
        return list.get(variant);
    }

    @Override
    public LandForms getLandforms() {
        return this.landForms;
    }

    @Override
    public List<Populator> getPopulators() {
        List<TerrainPopulator> mixed = StandardTerrainProvider.combine(StandardTerrainProvider.getMixable(this.mixable), this::combine);
        ArrayList<Populator> result = new ArrayList<Populator>(mixed.size() + this.unmixable.size());
        result.addAll(mixed);
        result.addAll(this.unmixable);
        return result;
    }

    public List<TerrainPopulator> getTerrainPopulators() {
        ArrayList<TerrainPopulator> populators = new ArrayList<TerrainPopulator>();
        populators.addAll(this.mixable);
        populators.addAll(this.unmixable);
        return populators;
    }

    protected GeneratorContext getContext() {
        return this.context;
    }

    private TerrainPopulator combine(TerrainPopulator tp1, TerrainPopulator tp2) {
        return this.combine(tp1, tp2, this.context.seed, this.config.scale / 2);
    }

    private TerrainPopulator combine(TerrainPopulator tp1, TerrainPopulator tp2, Seed seed, int scale) {
        MixedTerarin type = new MixedTerarin(tp1.getType(), tp2.getType());
        Module combined = Source.perlin(seed.next(), scale, 1).warp(seed.next(), scale / 2, 2, (double)scale / 2.0).blend(tp1.getVariance(), tp2.getVariance(), 0.5, 0.25).clamp(0.0, 1.0);
        return new TerrainPopulator(type, this.landForms.getLandBase(), combined);
    }

    private static <T> List<T> combine(List<T> input, BiFunction<T, T, T> operator) {
        int i;
        int length = input.size();
        for (int i2 = 1; i2 < input.size(); ++i2) {
            length += input.size() - i2;
        }
        ArrayList<T> result = new ArrayList<T>(length);
        for (i = 0; i < length; ++i) {
            result.add(null);
        }
        int k = input.size();
        for (i = 0; i < input.size(); ++i) {
            T t1 = input.get(i);
            result.set(i, t1);
            int j = i + 1;
            while (j < input.size()) {
                T t2 = input.get(j);
                T t3 = operator.apply(t1, t2);
                result.set(k, t3);
                ++j;
                ++k;
            }
        }
        return result;
    }

    private static List<TerrainPopulator> getMixable(List<TerrainPopulator> input) {
        ArrayList<TerrainPopulator> output = new ArrayList<TerrainPopulator>(input.size());
        for (TerrainPopulator populator : input) {
            if (!(populator.getType().getWeight() > 0.0f)) continue;
            output.add(populator);
        }
        return output;
    }
}

